/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessageToServer;
import de.maxhenkel.camera.proxy.CommonProxy;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageRequestImage
extends MessageToServer<MessageRequestImage> {
    private UUID imgUUID;

    public MessageRequestImage() {
    }

    public MessageRequestImage(UUID imgUUID) {
        this.imgUUID = imgUUID;
    }

    @Override
    public void execute(EntityPlayerMP player, MessageRequestImage message) {
        try {
            byte[] data = ImageTools.toBytes(CommonProxy.packetManager.getExistingImage(player, message.imgUUID));
            CommonProxy.simpleNetworkWrapper.sendTo((IMessage)new MessageImage(message.imgUUID, data), player);
        }
        catch (IOException e) {
            e.printStackTrace();
            CommonProxy.simpleNetworkWrapper.sendTo((IMessage)new MessageImageUnavailable(message.imgUUID), player);
        }
    }

    public void fromBytes(ByteBuf buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.imgUUID = new UUID(l1, l2);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.imgUUID.getMostSignificantBits());
        buf.writeLong(this.imgUUID.getLeastSignificantBits());
    }
}

