/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.network.PacketHandler;
import com.mrcrayfish.obfuscate.network.handshake.ObfuscateMessage;
import com.mrcrayfish.obfuscate.network.message.MessageSyncPlayerData;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.Validate;

public class SyncedPlayerData {
    public static final Capability<DataHolder> CAPABILITY = null;
    private static SyncedPlayerData instance;
    private static boolean init;
    private final Map<ResourceLocation, SyncedDataKey<?>> registeredDataKeys = new HashMap();
    private final Map<Integer, SyncedDataKey<?>> idToDataKey = new HashMap();
    private int nextKeyId = 0;
    private boolean dirty = false;

    private SyncedPlayerData() {
    }

    public static SyncedPlayerData instance() {
        if (instance == null) {
            instance = new SyncedPlayerData();
        }
        return instance;
    }

    public static void init() {
        if (!init) {
            SyncedPlayerData.injectCapability();
            MinecraftForge.EVENT_BUS.register((Object)SyncedPlayerData.instance());
            init = true;
        }
    }

    private static void injectCapability() {
        try {
            String realName = DataHolder.class.getName().intern();
            Constructor constructor = Capability.class.getDeclaredConstructor(String.class, Capability.IStorage.class, Callable.class);
            constructor.setAccessible(true);
            Capability cap = (Capability)constructor.newInstance(realName, new Storage(), () -> new DataHolder());
            Field field = SyncedPlayerData.class.getDeclaredField("CAPABILITY");
            EnumHelper.setFailsafeFieldValue((Field)field, null, (Object)cap);
            Obfuscate.LOGGER.info("Successfully injected SyncedPlayerData capability");
        }
        catch (Exception e) {
            Obfuscate.LOGGER.fatal("Failed to initialize capability!");
            e.printStackTrace();
        }
    }

    public void registerKey(SyncedDataKey<?> key) {
        if (this.registeredDataKeys.containsKey(key.getKey())) {
            throw new IllegalArgumentException(String.format("The data key '%s' is already registered!", key.getKey()));
        }
        int nextId = this.nextKeyId++;
        key.setId(nextId);
        this.registeredDataKeys.put(key.getKey(), key);
        this.idToDataKey.put(nextId, key);
    }

    public <T> void set(EntityPlayer player, SyncedDataKey<T> key, T value) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        if (holder != null && holder.set(player, key, value) && !player.field_70170_p.field_72995_K) {
            this.dirty = true;
        }
    }

    public <T> T get(EntityPlayer player, SyncedDataKey<T> key) {
        if (!this.registeredDataKeys.values().contains(key)) {
            throw new IllegalArgumentException(String.format("The data key '%s' is not registered!", key.getKey()));
        }
        DataHolder holder = this.getDataHolder(player);
        return holder != null ? holder.get(key) : key.getDefaultValueSupplier().get();
    }

    @Nullable
    public SyncedDataKey<?> getKey(int id) {
        return this.idToDataKey.get(id);
    }

    public List<SyncedDataKey<?>> getKeys() {
        return ImmutableList.copyOf(this.registeredDataKeys.values());
    }

    @Nullable
    private DataHolder getDataHolder(EntityPlayer player) {
        return (DataHolder)player.getCapability(CAPABILITY, null);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("obfuscate", "synced_player_data"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player;
        DataHolder holder;
        if (event.getTarget() instanceof EntityPlayer && !event.getEntityPlayer().field_70170_p.field_72995_K && (holder = this.getDataHolder(player = (EntityPlayer)event.getTarget())) != null) {
            List<DataEntry<?>> entries = holder.gatherAll();
            entries.removeIf(entry -> !entry.getKey().shouldSyncToAllPlayers());
            if (!entries.isEmpty()) {
                PacketHandler.getPlayChannel().sendTo((IMessage)new MessageSyncPlayerData(player.func_145782_y(), entries), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        List<DataEntry<?>> entries;
        EntityPlayer player;
        DataHolder holder;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !event.getWorld().field_72995_K && (holder = this.getDataHolder(player = (EntityPlayer)entity)) != null && !(entries = holder.gatherAll()).isEmpty()) {
            PacketHandler.getPlayChannel().sendTo((IMessage)new MessageSyncPlayerData(player.func_145782_y(), entries), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.getOriginal();
        if (!original.field_70170_p.field_72995_K) {
            DataHolder newHolder;
            EntityPlayer player = event.getEntityPlayer();
            DataHolder oldHolder = this.getDataHolder(original);
            if (oldHolder != null && (newHolder = this.getDataHolder(player)) != null) {
                HashMap dataMap = new HashMap(oldHolder.dataMap);
                if (event.isWasDeath()) {
                    dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).isPersistent());
                }
                newHolder.dataMap = dataMap;
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            DataHolder holder;
            EntityPlayer player = event.player;
            if (!player.field_70170_p.field_72995_K && (holder = this.getDataHolder(player)) != null && holder.isDirty()) {
                List<DataEntry<?>> entries = holder.gatherDirty();
                if (!entries.isEmpty()) {
                    PacketHandler.getPlayChannel().sendTo((IMessage)new MessageSyncPlayerData(player.func_145782_y(), entries), (EntityPlayerMP)player);
                    List<DataEntry<?>> syncToAllEntries = entries.stream().filter(entry -> entry.getKey().shouldSyncToAllPlayers()).collect(Collectors.toList());
                    if (!syncToAllEntries.isEmpty()) {
                        PacketHandler.getPlayChannel().sendToAllTracking((IMessage)new MessageSyncPlayerData(player.func_145782_y(), syncToAllEntries), (Entity)player);
                    }
                }
                holder.clean();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.dirty) {
            this.dirty = false;
        }
    }

    public boolean updateMappings(ObfuscateMessage.SyncedPlayerDataMessage message) {
        Obfuscate.LOGGER.info(String.format("Updating %d synced key mappings", message.getKeyMap().size()));
        this.idToDataKey.clear();
        Map<ResourceLocation, Integer> keyMappings = message.getKeyMap();
        for (ResourceLocation key : keyMappings.keySet()) {
            SyncedDataKey<?> syncedDataKey = this.registeredDataKeys.get(key);
            if (syncedDataKey == null) {
                return false;
            }
            int id = keyMappings.get(key);
            syncedDataKey.setId(id);
            this.idToDataKey.put(id, syncedDataKey);
        }
        return true;
    }

    static {
        init = false;
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagList> {
        final DataHolder INSTANCE = (DataHolder)CAPABILITY.getDefaultInstance();

        public NBTTagList serializeNBT() {
            return (NBTTagList)CAPABILITY.getStorage().writeNBT(CAPABILITY, (Object)this.INSTANCE, null);
        }

        public void deserializeNBT(NBTTagList compound) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, (Object)this.INSTANCE, null, (NBTBase)compound);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        @Nonnull
        public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
            return (T)(this.hasCapability(cap, side) ? CAPABILITY.cast((Object)this.INSTANCE) : null);
        }
    }

    public static class Storage
    implements Capability.IStorage<DataHolder> {
        @Nullable
        public NBTBase writeNBT(Capability<DataHolder> capability, DataHolder instance, EnumFacing side) {
            NBTTagList list = new NBTTagList();
            instance.dataMap.forEach((key, entry) -> {
                if (key.shouldSave()) {
                    NBTTagCompound keyTag = new NBTTagCompound();
                    keyTag.func_74778_a("Key", key.getKey().toString());
                    keyTag.func_74782_a("Value", ((DataEntry)entry).writeValue());
                    list.func_74742_a((NBTBase)keyTag);
                }
            });
            return list;
        }

        public void readNBT(Capability<DataHolder> capability, DataHolder instance, EnumFacing side, NBTBase nbt) {
            NBTTagList list = (NBTTagList)nbt;
            list.forEach(entryTag -> {
                NBTTagCompound keyTag = (NBTTagCompound)entryTag;
                ResourceLocation key = new ResourceLocation(keyTag.func_74779_i("Key"));
                NBTBase value = keyTag.func_74781_a("Value");
                SyncedDataKey syncedDataKey = (SyncedDataKey)SyncedPlayerData.instance().registeredDataKeys.get(key);
                if (syncedDataKey != null && syncedDataKey.shouldSave()) {
                    DataEntry entry = new DataEntry(syncedDataKey);
                    entry.readValue(value);
                    instance.dataMap.put(syncedDataKey, entry);
                }
            });
        }
    }

    public static class DataEntry<T> {
        private SyncedDataKey<T> key;
        private T value;
        private boolean dirty;

        private DataEntry(SyncedDataKey<T> key) {
            this.key = key;
            this.value = key.getDefaultValueSupplier().get();
        }

        public SyncedDataKey<T> getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
        }

        public void write(ByteBuf buffer) {
            ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.key.getId(), (int)4);
            this.key.getSerializer().write(buffer, this.value);
        }

        public static DataEntry<?> read(ByteBuf buffer) {
            SyncedDataKey<?> key = SyncedPlayerData.instance().getKey(ByteBufUtils.readVarInt((ByteBuf)buffer, (int)4));
            Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
            DataEntry entry = new DataEntry(key);
            super.readValue(buffer);
            return entry;
        }

        private void readValue(ByteBuf buffer) {
            this.value = this.getKey().getSerializer().read(buffer);
        }

        private NBTBase writeValue() {
            return this.key.getSerializer().write(this.value);
        }

        private void readValue(NBTBase nbt) {
            this.value = this.key.getSerializer().read(nbt);
        }
    }

    public static class DataHolder {
        private Map<SyncedDataKey<?>, DataEntry<?>> dataMap = new HashMap();
        private boolean dirty = false;

        public <T> boolean set(EntityPlayer player, SyncedDataKey<T> key, T value) {
            DataEntry entry = this.dataMap.computeIfAbsent(key, x$0 -> new DataEntry((SyncedDataKey)x$0));
            if (!entry.getValue().equals(value)) {
                boolean dirty = !player.field_70170_p.field_72995_K && entry.getKey().shouldSyncToClient();
                entry.setValue(value, dirty);
                this.dirty = dirty;
                return true;
            }
            return false;
        }

        @Nullable
        public <T> T get(SyncedDataKey<T> key) {
            return this.dataMap.computeIfAbsent(key, x$0 -> new DataEntry((SyncedDataKey)x$0)).getValue();
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
            this.dataMap.forEach((key, entry) -> entry.clean());
        }

        public List<DataEntry<?>> gatherDirty() {
            return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().shouldSyncToClient()).collect(Collectors.toList());
        }

        public List<DataEntry<?>> gatherAll() {
            return this.dataMap.values().stream().filter(entry -> entry.getKey().shouldSyncToClient()).collect(Collectors.toList());
        }
    }
}

