/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network.handshake;

import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class ObfuscateMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class SyncedPlayerDataMessage
    extends ObfuscateMessage {
        private Map<ResourceLocation, Integer> keyMap = new HashMap<ResourceLocation, Integer>();

        public SyncedPlayerDataMessage() {
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> this.keyMap.put(syncedDataKey.getKey(), syncedDataKey.getId()));
        }

        @Override
        void toBytes(ByteBuf bytes) {
            bytes.writeInt(this.keyMap.size());
            this.keyMap.forEach((key, id) -> {
                ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)key.toString());
                ByteBufUtils.writeVarInt((ByteBuf)bytes, (int)id, (int)2);
            });
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            this.keyMap = new HashMap<ResourceLocation, Integer>();
            int size = bytes.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation key = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)bytes));
                int id = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)2);
                this.keyMap.put(key, id);
            }
        }

        public Map<ResourceLocation, Integer> getKeyMap() {
            return this.keyMap;
        }
    }
}

