/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.modeldata;

import com.jaquadro.minecraft.chameleon.model.ModelData;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import java.util.Arrays;
import java.util.UUID;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public final class DrawerStateModelData
extends ModelData {
    @CapabilityInject(value=IDrawerAttributes.class)
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private final boolean shroudedFlag;
    private final boolean lockedFlag;
    private final boolean voidFlag;
    private final UUID owner;
    private final boolean[] emptyFlags;

    public DrawerStateModelData(TileEntityDrawers tile) {
        IDrawerAttributes attr = null;
        if (tile != null) {
            attr = tile.getCapability(DRAWER_ATTRIBUTES_CAPABILITY, null);
        }
        if (tile != null && attr != null) {
            this.shroudedFlag = attr.isConcealed();
            this.lockedFlag = attr.isItemLocked(LockAttribute.LOCK_POPULATED);
            this.voidFlag = attr.isVoid();
            this.owner = tile.getOwner();
            this.emptyFlags = new boolean[tile.getDrawerCount()];
            for (int i = 0; i < this.emptyFlags.length; ++i) {
                IDrawer drawer = tile.getDrawer(i);
                this.emptyFlags[i] = drawer == null || drawer.isEmpty();
            }
        } else {
            this.shroudedFlag = false;
            this.lockedFlag = false;
            this.voidFlag = false;
            this.owner = null;
            this.emptyFlags = new boolean[0];
        }
    }

    public boolean isShrouded() {
        return this.shroudedFlag;
    }

    public boolean isItemLocked() {
        return this.lockedFlag;
    }

    public boolean isVoid() {
        return this.voidFlag;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public int getDrawerCount() {
        return this.emptyFlags.length;
    }

    public boolean isDrawerEmpty(int slot) {
        return slot < 0 || slot >= this.emptyFlags.length || this.emptyFlags[slot];
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        DrawerStateModelData other = (DrawerStateModelData)((Object)obj);
        if (this.shroudedFlag != other.shroudedFlag || this.lockedFlag != other.lockedFlag || this.voidFlag != other.voidFlag) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(other.owner) || this.owner == null && other.owner != null) {
            return false;
        }
        return Arrays.equals(this.emptyFlags, other.emptyFlags);
    }

    public int hashCode() {
        int c = this.shroudedFlag ? 1 : 0;
        c = 37 * c + (this.lockedFlag ? 1 : 0);
        c = 37 * c + (this.voidFlag ? 1 : 0);
        c = 37 * c + (this.owner != null ? this.owner.hashCode() : 0);
        for (boolean emptyFlag : this.emptyFlags) {
            c = 37 * c + (emptyFlag ? 1 : 0);
        }
        return c;
    }
}

