/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.util.ItemMetaRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;

public class ItemMetaCollectionRegistry<E> {
    private ItemMetaRegistry<Collection<E>> registry;
    private boolean compactTopLevel;

    public ItemMetaCollectionRegistry() {
        this(false);
    }

    public ItemMetaCollectionRegistry(boolean compactTopLevel) {
        this.registry = new ItemMetaRegistry(compactTopLevel);
        this.compactTopLevel = compactTopLevel;
    }

    public void register(Item item, int meta, E entry) {
        Collection<E> list = this.registry.getEntry(item, meta);
        if (list == null) {
            list = new TreeSet();
            this.registry.register(item, meta, list);
        }
        list.add(entry);
    }

    public Collection<E> getEntries(Item item, int meta) {
        return this.registry.getEntry(item, meta);
    }

    public void remove(Item item, int meta) {
        this.registry.remove(item, meta);
    }

    public void clear(Item item, int meta) {
        Collection<E> list = this.registry.getEntry(item, meta);
        if (list != null) {
            list.clear();
        }
    }

    public void clear(Item item) {
        for (Map.Entry<Integer, Collection<E>> map : this.registry.entrySet(item)) {
            map.getValue().clear();
        }
    }

    public void clear() {
        for (Map.Entry<Item, Map<Integer, Collection<E>>> map : this.registry.entrySet()) {
            for (Collection<E> list : map.getValue().values()) {
                list.clear();
            }
        }
    }

    public Set<Map.Entry<Item, Map<Integer, Collection<E>>>> entrySet() {
        return this.registry.entrySet();
    }
}

