/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.qubble.QubbleAnimation;
import net.ilexiconn.llibrary.client.model.qubble.QubbleCuboid;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleModel
implements INBTSerializable<NBTTagCompound> {
    private String name;
    private String author;
    private int version;
    private int textureWidth = 64;
    private int textureHeight = 32;
    private List<QubbleCuboid> cuboids = new ArrayList<QubbleCuboid>();
    private List<QubbleAnimation> animations = new ArrayList<QubbleAnimation>();
    private transient String fileName;
    private Map<String, String> textures = new LinkedHashMap<String, String>();

    private QubbleModel() {
    }

    public static QubbleModel create(String name, String author, int textureWidth, int textureHeight) {
        QubbleModel model = new QubbleModel();
        model.setName(name == null ? "Unknown" : name);
        model.setAuthor(author == null ? "Unknown" : author);
        model.setTextureWidth(textureWidth);
        model.setTextureHeight(textureHeight);
        model.setVersion(LLibrary.QUBBLE_VERSION);
        return model;
    }

    public static QubbleModel deserialize(NBTTagCompound compound) {
        QubbleModel model = new QubbleModel();
        model.deserializeNBT(compound);
        return model;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("author", this.author);
        compound.func_74768_a("version", this.version);
        if (this.textureWidth != 64 || this.textureHeight != 32) {
            NBTTagCompound textureTag = new NBTTagCompound();
            textureTag.func_74768_a("width", this.textureWidth);
            textureTag.func_74768_a("height", this.textureHeight);
            compound.func_74782_a("texture", (NBTBase)textureTag);
        }
        NBTTagList cuboidTag = new NBTTagList();
        for (QubbleCuboid qubbleCuboid : this.cuboids) {
            cuboidTag.func_74742_a((NBTBase)qubbleCuboid.serializeNBT());
        }
        compound.func_74782_a("cuboids", (NBTBase)cuboidTag);
        NBTTagList animationsTag = new NBTTagList();
        for (QubbleAnimation animation : this.animations) {
            animationsTag.func_74742_a((NBTBase)animation.serializeNBT());
        }
        compound.func_74782_a("animations", (NBTBase)animationsTag);
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<String, String> entry : this.textures.entrySet()) {
            NBTTagCompound texture = new NBTTagCompound();
            texture.func_74778_a("key", entry.getKey());
            texture.func_74778_a("value", entry.getValue());
            nBTTagList.func_74742_a((NBTBase)texture);
        }
        compound.func_74782_a("textures", (NBTBase)nBTTagList);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.author = compound.func_74779_i("author");
        this.version = compound.func_74762_e("version");
        if (compound.func_74764_b("texture")) {
            NBTTagCompound textureTag = compound.func_74775_l("texture");
            this.textureWidth = textureTag.func_74762_e("width");
            this.textureHeight = textureTag.func_74762_e("height");
        }
        this.cuboids = new ArrayList<QubbleCuboid>();
        NBTTagList cuboidTag = compound.func_150295_c("cuboids", 10);
        for (int i = 0; i < cuboidTag.func_74745_c(); ++i) {
            this.cuboids.add(QubbleCuboid.deserialize(cuboidTag.func_150305_b(i)));
        }
        NBTTagList animationsTag = compound.func_150295_c("animations", 10);
        for (int i = 0; i < animationsTag.func_74745_c(); ++i) {
            this.animations.add(QubbleAnimation.deserialize(animationsTag.func_150305_b(i)));
        }
        if (compound.func_74764_b("textures")) {
            NBTTagList textures = compound.func_150295_c("textures", 10);
            for (int i = 0; i < textures.func_74745_c(); ++i) {
                NBTTagCompound texture = textures.func_150305_b(i);
                if (!texture.func_74764_b("key") || !texture.func_74764_b("value")) continue;
                this.textures.put(texture.func_74779_i("key"), texture.func_74779_i("value"));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public void setTextureWidth(int textureWidth) {
        this.textureWidth = textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public void setTextureHeight(int textureHeight) {
        this.textureHeight = textureHeight;
    }

    public List<QubbleCuboid> getCuboids() {
        return this.cuboids;
    }

    public List<QubbleAnimation> getAnimations() {
        return this.animations;
    }

    public String getTexture(String key) {
        return this.textures.get(key);
    }

    public void setTexture(String key, String value) {
        if (value == null) {
            this.textures.remove(key);
        } else {
            this.textures.put(key, value);
        }
    }

    public Map<String, String> getTextures() {
        return this.textures;
    }

    public void setTexture(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public void removeCuboid(QubbleCuboid cuboid) {
        for (QubbleCuboid currentCuboid : this.getCuboids()) {
            this.removeChildCuboid(currentCuboid, cuboid);
        }
    }

    private boolean removeChildCuboid(QubbleCuboid parent, QubbleCuboid cuboid) {
        boolean isChild = false;
        for (QubbleCuboid currentCuboid : parent.getChildren()) {
            if (currentCuboid.equals(cuboid)) {
                isChild = true;
                break;
            }
            if (!this.removeChildCuboid(currentCuboid, cuboid)) continue;
            return true;
        }
        if (isChild) {
            parent.getChildren().remove(cuboid);
            return true;
        }
        return false;
    }

    public QubbleCuboid getParent(QubbleCuboid cuboid) {
        for (QubbleCuboid currentCuboid : this.getCuboids()) {
            QubbleCuboid foundParent = this.getParent(currentCuboid, cuboid);
            if (foundParent == null) continue;
            return foundParent;
        }
        return null;
    }

    private QubbleCuboid getParent(QubbleCuboid parent, QubbleCuboid cuboid) {
        if (parent.getChildren().contains(cuboid)) {
            return parent;
        }
        for (QubbleCuboid child : parent.getChildren()) {
            QubbleCuboid foundParent = this.getParent(child, cuboid);
            if (foundParent == null) continue;
            return foundParent;
        }
        return null;
    }

    public QubbleModel unparent() {
        ArrayList<QubbleCuboid> unparentedCuboids = new ArrayList<QubbleCuboid>();
        for (QubbleCuboid cuboid : this.cuboids) {
            ArrayList<QubbleCuboid> parentCuboids = new ArrayList<QubbleCuboid>();
            parentCuboids.add(cuboid);
            unparentedCuboids.add(cuboid);
            this.unparentCuboids(new ArrayList<QubbleCuboid>(cuboid.getChildren()), unparentedCuboids, parentCuboids);
        }
        this.cuboids.clear();
        this.cuboids.addAll(unparentedCuboids);
        return this;
    }

    private void unparentCuboids(List<QubbleCuboid> cuboids, List<QubbleCuboid> childCuboids, List<QubbleCuboid> parentCuboids) {
        for (QubbleCuboid cuboid : cuboids) {
            ArrayList<QubbleCuboid> newParentCuboids = new ArrayList<QubbleCuboid>(parentCuboids);
            newParentCuboids.add(cuboid);
            float[][] transformation = this.getParentTransformation(newParentCuboids);
            ArrayList<QubbleCuboid> children = new ArrayList<QubbleCuboid>(cuboid.getChildren());
            QubbleCuboid newCube = QubbleCuboid.create(cuboid.getName());
            newCube.setName(cuboid.getName());
            newCube.setDimensions(cuboid.getDimensionX(), cuboid.getDimensionY(), cuboid.getDimensionZ());
            newCube.setPosition(transformation[0][0], transformation[0][1], transformation[0][2]);
            newCube.setOffset(cuboid.getOffsetX(), cuboid.getOffsetY(), cuboid.getOffsetZ());
            newCube.setRotation(transformation[1][0], transformation[1][1], transformation[1][2]);
            newCube.setScale(cuboid.getScaleX(), cuboid.getScaleY(), cuboid.getScaleZ());
            newCube.setTexture(cuboid.getTextureX(), cuboid.getTextureY());
            newCube.setTextureMirrored(cuboid.isTextureMirrored());
            newCube.setOpacity(cuboid.getOpacity());
            childCuboids.add(newCube);
            this.unparentCuboids(children, childCuboids, new ArrayList<QubbleCuboid>(newParentCuboids));
        }
    }

    private float[][] getParentTransformation(List<QubbleCuboid> parentCuboids) {
        double cosRotationAngleZ;
        double sinRotationAngleZ;
        double cosRotationAngleX;
        double sinRotationAngleX;
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        Matrix4d transform = new Matrix4d();
        for (QubbleCuboid cuboid : parentCuboids) {
            transform.setIdentity();
            transform.setTranslation(new Vector3d((double)cuboid.getPositionX(), (double)cuboid.getPositionY(), (double)cuboid.getPositionZ()));
            matrix.mul(transform);
            transform.rotZ((double)(cuboid.getRotationZ() / 180.0f) * Math.PI);
            matrix.mul(transform);
            transform.rotY((double)(cuboid.getRotationY() / 180.0f) * Math.PI);
            matrix.mul(transform);
            transform.rotX((double)(cuboid.getRotationX() / 180.0f) * Math.PI);
            matrix.mul(transform);
        }
        double sinRotationAngleY = -matrix.m20;
        double cosRotationAngleY = Math.sqrt(1.0 - sinRotationAngleY * sinRotationAngleY);
        if (Math.abs(cosRotationAngleY) > 1.0E-4) {
            sinRotationAngleX = matrix.m21 / cosRotationAngleY;
            cosRotationAngleX = matrix.m22 / cosRotationAngleY;
            sinRotationAngleZ = matrix.m10 / cosRotationAngleY;
            cosRotationAngleZ = matrix.m00 / cosRotationAngleY;
        } else {
            sinRotationAngleX = -matrix.m12;
            cosRotationAngleX = matrix.m11;
            sinRotationAngleZ = 0.0;
            cosRotationAngleZ = 1.0;
        }
        float rotationAngleX = (float)((double)this.epsilon((float)Math.atan2(sinRotationAngleX, cosRotationAngleX)) / Math.PI * 180.0);
        float rotationAngleY = (float)((double)this.epsilon((float)Math.atan2(sinRotationAngleY, cosRotationAngleY)) / Math.PI * 180.0);
        float rotationAngleZ = (float)((double)this.epsilon((float)Math.atan2(sinRotationAngleZ, cosRotationAngleZ)) / Math.PI * 180.0);
        return new float[][]{{this.epsilon((float)matrix.m03), this.epsilon((float)matrix.m13), this.epsilon((float)matrix.m23)}, {rotationAngleX, rotationAngleY, rotationAngleZ}};
    }

    private float epsilon(float x) {
        return x < 0.0f ? (x > -1.0E-4f ? 0.0f : x) : (x < 1.0E-4f ? 0.0f : x);
    }

    public QubbleModel copy() {
        QubbleModel model = QubbleModel.create(this.getName(), this.getAuthor(), this.getTextureWidth(), this.getTextureHeight());
        model.getCuboids().addAll(this.getCuboids().stream().map(QubbleCuboid::copy).collect(Collectors.toList()));
        model.getAnimations().addAll(this.getAnimations().stream().map(QubbleAnimation::copy).collect(Collectors.toList()));
        model.setFileName(this.getFileName());
        model.getTextures().putAll(this.getTextures());
        return model;
    }
}

