/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.slider;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.slider.AbstractHandledSlider;
import java.util.function.Consumer;
import net.minecraft.util.math.MathHelper;

public abstract class AdvancedSliderButton
extends AbstractHandledSlider {
    protected String messagePrefix = null;
    protected String messageSuffix = null;
    protected Consumer<AdvancedSliderButton> applyValueCallback;

    public AdvancedSliderButton(int x, int y, int width, int height, boolean handleClick, double value, Consumer<AdvancedSliderButton> applyValueCallback) {
        super(x, y, width, height, "", value);
        this.applyValueCallback = applyValueCallback;
    }

    @Override
    protected void applyValue() {
        if (this.applyValueCallback != null) {
            this.applyValueCallback.accept(this);
        }
    }

    @Override
    public void updateMessage() {
        String s = "";
        if (this.messagePrefix != null) {
            s = s + this.messagePrefix;
        }
        s = s + this.getSliderMessageWithoutPrefixSuffix();
        if (this.messageSuffix != null) {
            s = s + this.messageSuffix;
        }
        this.field_146126_j = s;
    }

    public abstract String getSliderMessageWithoutPrefixSuffix();

    public void setLabelPrefix(String prefix) {
        this.messagePrefix = prefix;
        this.updateMessage();
    }

    public void setLabelSuffix(String suffix) {
        this.messageSuffix = suffix;
        this.updateMessage();
    }

    public void setValue(double value) {
        double d0 = this.value;
        this.value = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        if (d0 != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public double getValue() {
        return this.value;
    }
}

