/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.gui;

import com.mrcrayfish.vehicle.common.container.ContainerFluidMixer;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidMixer;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluidMixer
extends GuiContainer {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/fluid_mixer.png");
    private IInventory playerInventory;
    private TileEntityFluidMixer tileEntityFluidMixer;

    public GuiFluidMixer(IInventory playerInventory, TileEntityFluidMixer tileEntityFluidMixer) {
        super((Container)new ContainerFluidMixer(playerInventory, tileEntityFluidMixer));
        this.playerInventory = playerInventory;
        this.tileEntityFluidMixer = tileEntityFluidMixer;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        FluidStack stack;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tileEntityFluidMixer.getBlazeFluidStack() != null) {
            stack = this.tileEntityFluidMixer.getBlazeFluidStack();
            if (this.isMouseWithinRegion(startX + 33, startY + 17, 16, 29, mouseX, mouseY)) {
                if (stack.amount > 0) {
                    this.func_146283_a(Arrays.asList(stack.getLocalizedName(), TextFormatting.GRAY.toString() + this.tileEntityFluidMixer.getBlazeLevel() + "/" + 5000 + " mB"), mouseX, mouseY);
                } else {
                    this.func_146283_a(Collections.singletonList("No Fluid"), mouseX, mouseY);
                }
            }
        }
        if (this.tileEntityFluidMixer.getEnderSapFluidStack() != null) {
            stack = this.tileEntityFluidMixer.getEnderSapFluidStack();
            if (this.isMouseWithinRegion(startX + 33, startY + 52, 16, 29, mouseX, mouseY)) {
                if (stack.amount > 0) {
                    this.func_146283_a(Arrays.asList(stack.getLocalizedName(), TextFormatting.GRAY.toString() + this.tileEntityFluidMixer.getEnderSapLevel() + "/" + 5000 + " mB"), mouseX, mouseY);
                } else {
                    this.func_146283_a(Collections.singletonList("No Fluid"), mouseX, mouseY);
                }
            }
        }
        if (this.tileEntityFluidMixer.getFueliumFluidStack() != null) {
            stack = this.tileEntityFluidMixer.getFueliumFluidStack();
            if (this.isMouseWithinRegion(startX + 151, startY + 20, 16, 59, mouseX, mouseY)) {
                if (stack.amount > 0) {
                    this.func_146283_a(Arrays.asList(stack.getLocalizedName(), TextFormatting.GRAY.toString() + this.tileEntityFluidMixer.getFueliumLevel() + "/" + 10000 + " mB"), mouseX, mouseY);
                } else {
                    this.func_146283_a(Collections.singletonList("No Fluid"), mouseX, mouseY);
                }
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileEntityFluidMixer.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tileEntityFluidMixer.getRemainingFuel() > 0) {
            int remainingFuel = (int)(14.0 * ((double)this.tileEntityFluidMixer.getRemainingFuel() / (double)this.tileEntityFluidMixer.getFuelMaxProgress()));
            this.func_73729_b(startX + 9, startY + 31 + 14 - remainingFuel, 176, 14 - remainingFuel, 14, remainingFuel + 1);
        }
        if (this.tileEntityFluidMixer.getExtractionProgress() > 0) {
            int colorFade;
            int alpha;
            int blazeColorRGB = FluidUtils.getAverageFluidColor(this.tileEntityFluidMixer.getBlazeFluidStack().getFluid());
            int sapColorRGB = FluidUtils.getAverageFluidColor(this.tileEntityFluidMixer.getEnderSapFluidStack().getFluid());
            int blazeColor = 0x82000000 | blazeColorRGB;
            int sapColor = 0x82000000 | sapColorRGB;
            int redBlaze = blazeColor >> 16 & 0xFF;
            int greenBlaze = blazeColor >> 8 & 0xFF;
            int blueBlaze = blazeColor & 0xFF;
            int redSap = sapColor >> 16 & 0xFF;
            int greenSap = sapColor >> 8 & 0xFF;
            int blueSap = sapColor & 0xFF;
            int statrColorRGB = ((redBlaze + redSap) / 2 & 0xFF) << 16 | ((greenBlaze + greenSap) / 2 & 0xFF) << 8 | (blueBlaze + blueSap) / 2 & 0xFF;
            int statrColor = 0x82000000 | statrColorRGB;
            int fluidColor = 0x82000000 | FluidUtils.getAverageFluidColor(ModFluids.FUELIUM);
            double extractionPercentage = (double)this.tileEntityFluidMixer.getExtractionProgress() / 100.0;
            double lenghtItem = 76.0;
            double lenghtHorizontal = 12.0;
            double lenghtVerticle = 8.0;
            double lenghtNode = 10.0;
            double lenghtTotal = lenghtItem + lenghtHorizontal + lenghtVerticle + lenghtNode * 2.0;
            double percentageStart = 0.0;
            double percentageHorizontal = MathHelper.func_151237_a((double)((extractionPercentage - percentageStart) / (lenghtHorizontal / lenghtTotal)), (double)0.0, (double)1.0);
            int left = startX + 51;
            int top = startY + 27;
            this.func_73733_a(left, top, (int)((double)left + 12.0 * percentageHorizontal), top + 8, blazeColor, blazeColor);
            this.func_73733_a(left, top += 36, (int)((double)left + 12.0 * percentageHorizontal), top + 8, sapColor, sapColor);
            percentageStart += lenghtHorizontal / lenghtTotal;
            left += 12;
            top -= 37;
            if (extractionPercentage >= percentageStart) {
                alpha = (int)(130.0 * MathHelper.func_151237_a((double)((extractionPercentage - percentageStart) / (lenghtNode / lenghtTotal)), (double)0.0, (double)1.0));
                colorFade = alpha << 24 | blazeColorRGB;
                this.func_73733_a(left, top, left + 10, top + 10, colorFade, colorFade);
                colorFade = alpha << 24 | sapColorRGB;
                this.func_73733_a(left, top += 36, left + 10, top + 10, colorFade, colorFade);
            }
            percentageStart += lenghtNode / lenghtTotal;
            ++left;
            top -= 26;
            if (extractionPercentage >= percentageStart) {
                double percentageVerticle = MathHelper.func_151237_a((double)((extractionPercentage - percentageStart) / (lenghtVerticle / lenghtTotal)), (double)0.0, (double)1.0);
                this.func_73733_a(left, top, left + 8, (int)((double)top + 8.0 * percentageVerticle), blazeColor, blazeColor);
                this.func_73733_a(left, (int)((double)(top += 26) - 8.0 * percentageVerticle), left + 8, top, sapColor, sapColor);
            }
            percentageStart += lenghtVerticle / lenghtTotal;
            --left;
            top -= 18;
            if (extractionPercentage >= percentageStart) {
                alpha = (int)(130.0 * MathHelper.func_151237_a((double)((extractionPercentage - percentageStart) / (lenghtNode / lenghtTotal)), (double)0.0, (double)1.0));
                colorFade = alpha << 24 | statrColorRGB;
                this.func_73733_a(left, top, left + 10, top + 10, colorFade, colorFade);
            }
            if (extractionPercentage >= (percentageStart += lenghtNode / lenghtTotal)) {
                left = startX + 73;
                top = startY + 36;
                int right = left + 76;
                int bottom = top + 26;
                double percentageItem = MathHelper.func_151237_a((double)((extractionPercentage - percentageStart) / (lenghtItem / lenghtTotal)), (double)0.0, (double)1.0);
                RenderUtil.drawGradientRectHorizontal(left, top, right, bottom, statrColor, fluidColor, this.field_73735_i);
                this.func_73729_b(left, top, 176, 14, 76, 26);
                int extractionProgress = (int)(76.0 * percentageItem + 1.0);
                this.func_73729_b(left + extractionProgress, top, 73 + extractionProgress, 36, 76 - extractionProgress, 26);
            }
        }
        this.drawSmallFluidTank(this.tileEntityFluidMixer.getBlazeFluidStack(), startX + 33, startY + 17, (double)this.tileEntityFluidMixer.getBlazeLevel() / 5000.0);
        this.drawSmallFluidTank(this.tileEntityFluidMixer.getEnderSapFluidStack(), startX + 33, startY + 52, (double)this.tileEntityFluidMixer.getEnderSapLevel() / 5000.0);
        this.drawFluidTank(this.tileEntityFluidMixer.getFueliumFluidStack(), startX + 151, startY + 20, (double)this.tileEntityFluidMixer.getFueliumLevel() / 10000.0);
    }

    private void drawFluidTank(FluidStack fluid, int x, int y, double level) {
        FluidUtils.drawFluidTankInGUI(fluid, x, y, level, 59);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI);
        this.func_73729_b(x, y, 176, 44, 16, 59);
    }

    private void drawSmallFluidTank(FluidStack fluid, int x, int y, double level) {
        FluidUtils.drawFluidTankInGUI(fluid, x, y, level, 29);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI);
        this.func_73729_b(x, y, 176, 44, 16, 29);
    }

    private boolean isMouseWithinRegion(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

