/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageEntityFluid;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFluidTrailer
extends EntityTrailer
implements EntityRaytracer.IEntityRaytraceable,
IEntityAdditionalSpawnData {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(EntityFluidTrailer.createScaledBoundingBox(-0.4375, 0.26875, 0.875, 0.4375, 0.53125, 1.5, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();
    protected FluidTank tank = new FluidTank(100000){

        protected void onContentsChanged() {
            EntityFluidTrailer.this.syncTank();
        }
    };

    public EntityFluidTrailer(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.5f);
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af() && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return Collections.singletonList(CONNECTION_BOX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        RenderGlobal.func_189697_a((AxisAlignedBB)CONNECTION_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (result.getPartHit() == CONNECTION_BOX && rightClick) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public double getHitchOffset() {
        return -25.0;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Tank", 10)) {
            this.tank.readFromNBT(compound.func_74775_l("Tank"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        compound.func_74782_a("Tank", (NBTBase)tankTag);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void syncTank() {
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageEntityFluid(this.func_145782_y(), this.tank.getFluid()), (Entity)this);
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.tank.readFromNBT(Objects.requireNonNull(ByteBufUtils.readTag((ByteBuf)buffer)));
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        }
    }
}

