/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class InventoryUtil {
    private static final Random RANDOM = new Random();

    public static void writeInventoryToNBT(NBTTagCompound compound, String tagName, @Nullable IInventory inventory) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static <T extends IInventory> T readInventoryToNBT(NBTTagCompound compound, String tagName, T t) {
        if (compound.func_150297_b(tagName, 9)) {
            NBTTagList tagList = compound.func_150295_c(tagName, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slot = tagCompound.func_74771_c("Slot");
                if (slot < 0 || slot >= t.func_70302_i_()) continue;
                t.func_70299_a((int)slot, new ItemStack(tagCompound));
            }
        }
        return t;
    }

    public static void dropInventoryItems(World worldIn, double x, double y, double z, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            InventoryUtil.spawnItemStack(worldIn, x, y, z, itemstack);
        }
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float offsetX = -0.25f + RANDOM.nextFloat() * 0.5f;
        float offsetY = RANDOM.nextFloat() * 0.8f;
        float offsetZ = -0.25f + RANDOM.nextFloat() * 0.5f;
        while (!stack.func_190926_b()) {
            EntityItem entity = new EntityItem(worldIn, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            entity.field_70159_w = RANDOM.nextGaussian() * 0.05;
            entity.field_70181_x = RANDOM.nextGaussian() * 0.05 + 0.2;
            entity.field_70179_y = RANDOM.nextGaussian() * 0.05;
            worldIn.func_72838_d((Entity)entity);
        }
    }

    public static int getItemAmount(EntityPlayer player, Item item) {
        int amount = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            amount += stack.func_190916_E();
        }
        return amount;
    }

    public static boolean hasItemAndAmount(EntityPlayer player, Item item, int amount) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return amount <= count;
    }

    public static boolean removeItemWithAmount(EntityPlayer player, Item item, int amount) {
        if (InventoryUtil.hasItemAndAmount(player, item, amount)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
                if (amount - stack.func_190916_E() < 0) {
                    stack.func_190918_g(amount);
                    return true;
                }
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                if ((amount -= stack.func_190916_E()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getItemStackAmount(EntityPlayer player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean hasItemStack(EntityPlayer player, ItemStack find) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            count += stack.func_190916_E();
        }
        return find.func_190916_E() <= count;
    }

    public static boolean removeItemStack(EntityPlayer player, ItemStack find) {
        int amount = find.func_190916_E();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !InventoryUtil.areItemStacksEqualIgnoreCount(stack, find)) continue;
            if (amount - stack.func_190916_E() < 0) {
                stack.func_190918_g(amount);
                return true;
            }
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            if ((amount -= stack.func_190916_E()) != 0) continue;
            return true;
        }
        return false;
    }

    private static boolean areItemStacksEqualIgnoreCount(ItemStack source, ItemStack target) {
        if (source.func_77973_b() != target.func_77973_b()) {
            return false;
        }
        if (source.func_77952_i() != target.func_77952_i()) {
            return false;
        }
        if (source.func_77978_p() == null && target.func_77978_p() != null) {
            return false;
        }
        return (source.func_77978_p() == null || source.func_77978_p().equals((Object)target.func_77978_p())) && source.areCapsCompatible(target);
    }
}

