/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;

public class TileEntityFramingTable
extends TileEntity
implements IInventory {
    private ItemStack[] tableItemStacks = new ItemStack[5];
    private String customName;
    private static final AxisAlignedBB ZERO_EXTENT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TileEntityFramingTable() {
        for (int i = 0; i < this.tableItemStacks.length; ++i) {
            this.tableItemStacks[i] = ItemStack.field_190927_a;
        }
    }

    public int func_70302_i_() {
        return this.tableItemStacks.length;
    }

    public boolean func_191420_l() {
        for (ItemStack item : this.tableItemStacks) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.tableItemStacks[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        if (!this.tableItemStacks[slot].func_190926_b()) {
            if (this.tableItemStacks[slot].func_190916_E() <= count) {
                ItemStack stack = this.tableItemStacks[slot];
                this.tableItemStacks[slot] = ItemStack.field_190927_a;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.tableItemStacks[slot].func_77979_a(count);
            if (this.tableItemStacks[slot].func_190916_E() == 0) {
                this.tableItemStacks[slot] = ItemStack.field_190927_a;
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (!this.tableItemStacks[index].func_190926_b()) {
            ItemStack stack = this.tableItemStacks[index];
            this.tableItemStacks[index] = ItemStack.field_190927_a;
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.tableItemStacks[slot] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "storagedrawers.container.framingTable";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return TileEntityFramingTable.isItemValidDrawer(stack);
        }
        if (slot == 4) {
            return false;
        }
        if (slot >= 1 && slot < 4) {
            return TileEntityFramingTable.isItemValidMaterial(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public static boolean isItemValidDrawer(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block instanceof BlockDrawersCustom || block instanceof BlockTrimCustom;
    }

    public static boolean isItemValidMaterial(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return false;
        }
        IBlockState state = block.func_176203_a(stack.func_77960_j());
        return state.func_185914_p();
    }

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        NBTTagList itemList = tag.func_150295_c("Items", 10);
        this.tableItemStacks = new ItemStack[this.func_70302_i_()];
        for (i = 0; i < this.tableItemStacks.length; ++i) {
            this.tableItemStacks[i] = ItemStack.field_190927_a;
        }
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.tableItemStacks.length) continue;
            this.tableItemStacks[slot] = new ItemStack(item);
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.tableItemStacks.length; ++i) {
            if (this.tableItemStacks[i].func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.tableItemStacks[i].func_77955_b(item);
            itemList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 5, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockFramingTable) || !((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            return ZERO_EXTENT_AABB;
        }
        int side = ((EnumFacing)state.func_177229_b((IProperty)BlockFramingTable.FACING)).func_176745_a();
        int xOff = 0;
        int zOff = 0;
        if (side == 2) {
            xOff = 1;
        }
        if (side == 3) {
            xOff = -1;
        }
        if (side == 4) {
            zOff = -1;
        }
        if (side == 5) {
            zOff = 1;
        }
        int xMin = Math.min(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177958_n() + xOff);
        int xMax = Math.max(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177958_n() + xOff) + 1;
        int zMin = Math.min(this.field_174879_c.func_177952_p(), this.field_174879_c.func_177952_p() + zOff);
        int zMax = Math.max(this.field_174879_c.func_177952_p(), this.field_174879_c.func_177952_p() + zOff) + 1;
        return new AxisAlignedBB((double)xMin, (double)(this.field_174879_c.func_177956_o() + 1), (double)zMin, (double)xMax, (double)(this.field_174879_c.func_177956_o() + 2), (double)zMax);
    }
}

