/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.mrcrayfish.guns.entity.EntityThrowable;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityThrowableItem
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private ItemStack item = ItemStack.field_190927_a;
    private boolean shouldBounce;
    private float gravityVelocity = 0.03f;
    private int maxLife = 200;

    public EntityThrowableItem(World worldIn) {
        super(worldIn);
    }

    public EntityThrowableItem(World world, EntityPlayer player) {
        super(world, (EntityLivingBase)player);
    }

    public EntityThrowableItem(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected void setShouldBounce(boolean shouldBounce) {
        this.shouldBounce = shouldBounce;
    }

    protected void setGravityVelocity(float gravity) {
        this.gravityVelocity = gravity;
    }

    @Override
    protected float getGravityVelocity() {
        return this.gravityVelocity;
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shouldBounce && this.field_70173_aa >= this.maxLife) {
            this.func_70106_y();
            this.onDeath();
        }
    }

    public void onDeath() {
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        switch (result.field_72313_a) {
            case BLOCK: {
                if (this.shouldBounce) {
                    IBlockState state = this.field_70170_p.func_180495_p(result.func_178782_a());
                    SoundEvent event = state.func_177230_c().func_185467_w().func_185844_d();
                    double speed = Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70181_x, 2.0) + Math.pow(this.field_70179_y, 2.0));
                    if (speed > 0.1) {
                        this.field_70170_p.func_184148_a(null, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, event, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    }
                    EnumFacing facing = result.field_178784_b;
                    switch (facing.func_176740_k()) {
                        case X: {
                            this.field_70159_w = -this.field_70159_w * 0.5;
                            this.field_70181_x *= 0.75;
                            this.field_70179_y *= 0.75;
                            break;
                        }
                        case Y: {
                            this.field_70159_w *= 0.75;
                            this.field_70181_x = -this.field_70181_x * 0.25;
                            if (this.field_70181_x < (double)this.getGravityVelocity()) {
                                this.field_70181_x = 0.0;
                            }
                            this.field_70179_y *= 0.75;
                            break;
                        }
                        case Z: {
                            this.field_70159_w *= 0.75;
                            this.field_70181_x *= 0.75;
                            this.field_70179_y = -this.field_70179_y * 0.5;
                        }
                    }
                    break;
                }
                this.func_70106_y();
                this.onDeath();
                break;
            }
            case ENTITY: {
                Entity entity = result.field_72308_g;
                if (entity == null) break;
                break;
            }
        }
    }

    public boolean func_189652_ae() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.shouldBounce);
        buffer.writeFloat(this.gravityVelocity);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.item);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.shouldBounce = additionalData.readBoolean();
        this.gravityVelocity = additionalData.readFloat();
        this.item = ByteBufUtils.readItemStack((ByteBuf)additionalData);
    }
}

