/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.ModBlocks;

public class TorchRegistry {
    private static TorchRegistry megaTorchRegistry = new TorchRegistry("mega_torch", s -> s.func_177230_c() == ModBlocks.getMegaTorch());
    private static TorchRegistry dreadLampRegistry = new TorchRegistry("dread_lamp", s -> s.func_177230_c() == ModBlocks.getDreadLamp());
    private final String name;
    private final List<TorchLocation> torches = new ArrayList<TorchLocation>();
    private int torchRange;
    private int torchRangeSq;
    private Predicate<IBlockState> blockValidator;
    private int checkIndex = 0;

    public static TorchRegistry getMegaTorchRegistry() {
        return megaTorchRegistry;
    }

    public static TorchRegistry getDreadLampRegistry() {
        return dreadLampRegistry;
    }

    public TorchRegistry(String name, Predicate<IBlockState> blockValidator) {
        this.name = name;
        this.blockValidator = blockValidator;
    }

    public void setTorchRange(int torchRange) {
        this.torchRange = torchRange;
        this.torchRangeSq = torchRange * torchRange;
    }

    public void registerTorch(World world, BlockPos pos) {
        TorchLocation torchLoc = new TorchLocation(world.field_73011_w.getDimension(), pos);
        if (!this.torches.contains(torchLoc)) {
            this.torches.add(torchLoc);
        }
    }

    public void unregisterTorch(World world, BlockPos pos) {
        this.torches.remove(new TorchLocation(world.field_73011_w.getDimension(), pos));
    }

    public boolean isInRangeOfTorch(World world, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        for (TorchLocation torch : this.torches) {
            if (torch.DimensionId != dim) continue;
            double dx = (double)torch.Position.func_177958_n() + 0.5 - (double)pos.func_177958_n();
            double dy = Math.abs((double)torch.Position.func_177956_o() + 0.5 - (double)pos.func_177956_o());
            double dz = (double)torch.Position.func_177952_p() + 0.5 - (double)pos.func_177952_p();
            if (!(dx * dx + dz * dz <= (double)this.torchRangeSq) || !(dy <= (double)this.torchRange)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        NBTTagCompound nbt;
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/torchmaster_" + this.name + "_reg.dat");
        if (!file.exists()) {
            return;
        }
        try {
            nbt = CompressedStreamTools.func_74797_a((File)file);
            if (nbt == null) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        NBTTagList list = nbt.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            TorchLocation loc = new TorchLocation(entry);
            WorldServer world = DimensionManager.getWorld((int)loc.DimensionId);
            this.registerTorch((World)world, loc.Position);
        }
        TorchMasterMod.Log.debug("Loaded entries for " + this.name);
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/torchmaster_" + this.name + "_reg.dat");
        NBTTagList tagList = new NBTTagList();
        for (TorchLocation loc : this.torches) {
            tagList.func_74742_a((NBTBase)loc.toNbt());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("list", (NBTBase)tagList);
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)file);
            TorchMasterMod.Log.debug("Saved " + this.torches.size() + " entries for " + this.name + " to disk");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        if (this.torches.size() == 0) {
            return;
        }
        this.checkIndex = (this.checkIndex + 1) % this.torches.size();
        TorchLocation loc = this.torches.get(this.checkIndex);
        WorldServer world = DimensionManager.getWorld((int)loc.DimensionId);
        if (world == null) {
            return;
        }
        if (world.func_175667_e(loc.Position) && !this.blockValidator.test(world.func_180495_p(loc.Position))) {
            TorchMasterMod.Log.info("Torch @ " + loc + " is no longer valid, removing from registry");
        }
    }

    private class TorchLocation {
        public int DimensionId;
        public BlockPos Position;

        public TorchLocation(int dimensionId, BlockPos position) {
            this.DimensionId = dimensionId;
            this.Position = position;
        }

        public TorchLocation(NBTTagCompound entry) {
            this.DimensionId = entry.func_74762_e("d");
            this.Position = new BlockPos(entry.func_74762_e("x"), entry.func_74762_e("y"), entry.func_74762_e("z"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TorchLocation that = (TorchLocation)o;
            if (this.DimensionId != that.DimensionId) {
                return false;
            }
            return this.Position != null ? this.Position.equals((Object)that.Position) : that.Position == null;
        }

        public int hashCode() {
            int result = this.DimensionId;
            result = 31 * result + (this.Position != null ? this.Position.hashCode() : 0);
            return result;
        }

        public NBTTagCompound toNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("d", this.DimensionId);
            nbt.func_74768_a("x", this.Position.func_177958_n());
            nbt.func_74768_a("y", this.Position.func_177956_o());
            nbt.func_74768_a("z", this.Position.func_177952_p());
            return nbt;
        }

        public String toString() {
            return String.format("DIM: %d - %s", this.DimensionId, this.Position);
        }
    }
}

