/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.ai;

import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DinoAILeaveWater
extends EntityAIBase {
    private final EntityPrehistoricSwimming dino;
    private final double movementSpeed;
    private final World world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public DinoAILeaveWater(EntityPrehistoricSwimming thedinoIn, double movementSpeedIn) {
        this.dino = thedinoIn;
        this.movementSpeed = movementSpeedIn;
        this.world = thedinoIn.field_70170_p;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.dino.func_70090_H() || !this.dino.shouldLeaveWater()) {
            return false;
        }
        Vec3d vec3d = this.findPossibleShelter();
        if (vec3d == null) {
            return false;
        }
        this.shelterX = vec3d.field_72450_a;
        this.shelterY = vec3d.field_72448_b;
        this.shelterZ = vec3d.field_72449_c;
        return true;
    }

    public void func_75246_d() {
        double dist = this.dino.func_70011_f(this.shelterX + 0.5, this.shelterY + 1.5, this.shelterZ + 0.5);
        BlockPos blockpos = new BlockPos(this.shelterX, this.shelterY, this.shelterZ);
        if (this.shelterY > this.dino.func_174813_aQ().field_72338_b) {
            this.dino.func_70683_ar().func_75660_a();
            this.dino.field_70181_x += 0.25;
            this.dino.field_70159_w += (Math.signum((double)blockpos.func_177958_n() + 0.5 - this.dino.field_70165_t) * 0.5 - this.dino.field_70159_w) * 0.100000000372529;
            this.dino.field_70179_y += (Math.signum((double)blockpos.func_177952_p() + 0.5 - this.dino.field_70161_v) * 0.5 - this.dino.field_70179_y) * 0.100000000372529;
        }
        this.dino.func_70605_aq().func_75642_a(this.shelterX + 0.5, this.shelterY + 1.5, this.shelterZ + 0.5, this.movementSpeed);
    }

    public boolean func_75253_b() {
        return this.dino.func_70090_H();
    }

    public void func_75249_e() {
        this.dino.func_70661_as().func_75492_a(this.shelterX + 0.5, this.shelterY + 1.5, this.shelterZ + 0.5, this.movementSpeed);
    }

    @Nullable
    private Vec3d findPossibleShelter() {
        Random random = this.dino.func_70681_au();
        BlockPos blockpos = new BlockPos(this.dino.field_70165_t, this.dino.field_70163_u, this.dino.field_70161_v);
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, 1 + random.nextInt(6), random.nextInt(20) - 10);
            if (!this.world.func_180495_p(blockpos1).func_185914_p() || !this.world.func_175623_d(blockpos1.func_177984_a()) || blockpos1.func_177956_o() < blockpos.func_177956_o()) continue;
            return new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }
}

