/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import com.google.common.base.Optional;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFindWaterTarget;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILeapAtTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.ai.MeganeuraAIFollowOwner;
import fossilsarcheology.server.entity.ai.MeganeuraAIGetInWater;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityMeganeura
extends EntityPrehistoricSwimming {
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.func_187226_a(EntityMeganeura.class, (DataSerializer)DataSerializers.field_187201_k);
    protected static final DataParameter<EnumFacing> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityMeganeura.class, (DataSerializer)DataSerializers.field_187202_l);
    private int attachCooldown = 0;
    private int attachTicks = 0;

    public EntityMeganeura(World world) {
        super(world, PrehistoricEntityType.MEGANEURA, 1.0, 2.0, 4.0, 18.0, 0.15, 0.2, 0.0, 4.0);
        this.setActualSize(2.2f, 1.95f);
        this.minSize = 0.15f;
        this.maxSize = 0.3f;
        this.teenAge = 4;
        this.pediaScale = 45.0f;
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.field_70163_u, z);
        while (world.func_175623_d(pos.func_177977_b()) && pos.func_177956_o() > 0) {
            pos = pos.func_177977_b();
        }
        return pos.func_177981_b(2 + rand.nextInt(3));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(ATTACHED_BLOCK_POS, (Object)Optional.absent());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.attachCooldown = compound.func_74762_e("AttachCooldown");
        this.attachTicks = compound.func_74762_e("AttachTicks");
        if (compound.func_74764_b("APX")) {
            int i = compound.func_74762_e("APX");
            int j = compound.func_74762_e("APY");
            int k = compound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("AttachFace", (byte)((EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        BlockPos blockpos = this.getAttachmentPos();
        compound.func_74768_a("AttachCooldown", this.attachCooldown);
        compound.func_74768_a("AttachTicks", this.attachTicks);
        if (blockpos != null) {
            compound.func_74768_a("APX", blockpos.func_177958_n());
            compound.func_74768_a("APY", blockpos.func_177956_o());
            compound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public EnumFacing getAttachmentFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    @Nullable
    public BlockPos getAttachmentPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull();
    }

    public void setAttachmentPos(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.fromNullable((Object)pos));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Override
    public boolean func_70097_a(DamageSource dmg, float i) {
        if (dmg == DamageSource.field_76368_d) {
            return false;
        }
        this.attachTicks = 0;
        this.attachCooldown = 1000 + this.field_70146_Z.nextInt(1500);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.DOWN);
        this.setAttachmentPos(null);
        return super.func_70097_a(dmg, i);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.BONELESS_LOOT;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFindWaterTarget((EntityCreature)this, 10, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MeganeuraAIGetInWater(this, 1.0));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MeganeuraAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIWander());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoMeleeAttackAI(this, 1.5, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAILeapAtTarget(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
        this.field_70699_by.func_189566_q().func_186316_c(true);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean flying = this.isFlying();
        if (this.attachCooldown > 0) {
            --this.attachCooldown;
        }
        boolean flag = true;
        if (this.getAttachmentPos() == null) {
            this.attachTicks = 0;
            if (this.field_70132_H && this.attachCooldown == 0 && !this.field_70122_E) {
                BlockPos sidePos;
                this.attachCooldown = 5;
                Vec3d vec3d = this.func_174824_e(0.0f);
                Vec3d vec3d1 = this.func_70676_i(0.0f);
                Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 1.0, vec3d1.field_72448_b * 1.0, vec3d1.field_72449_c * 1.0);
                RayTraceResult rayTrace = this.field_70170_p.func_72901_a(vec3d, vec3d2, false);
                if (rayTrace != null && rayTrace.field_72307_f != null && this.field_70170_p.isSideSolid(sidePos = rayTrace.func_178782_a(), rayTrace.field_178784_b)) {
                    this.setAttachmentPos(sidePos);
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)rayTrace.field_178784_b.func_176734_d());
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            }
        } else if (flag) {
            BlockPos pos = this.getAttachmentPos();
            double dist = this.func_174831_c(pos);
            if (this.field_70170_p.isSideSolid(pos, this.getAttachmentFacing())) {
                ++this.attachTicks;
                this.attachCooldown = 150;
                this.field_70761_aq = 180.0f;
                this.field_70760_ar = 180.0f;
                this.field_70177_z = 180.0f;
                this.field_70126_B = 180.0f;
                this.field_70759_as = 180.0f;
                this.field_70758_at = 180.0f;
                this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            } else {
                this.attachTicks = 0;
                this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.DOWN);
                this.setAttachmentPos(null);
            }
        }
        if (this.attachTicks > 1150 && this.field_70146_Z.nextInt(123) == 0 || this.getAttachmentPos() != null && this.func_70638_az() != null) {
            this.attachTicks = 0;
            this.attachCooldown = 1000 + this.field_70146_Z.nextInt(1500);
            this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.DOWN);
            this.setAttachmentPos(null);
        }
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sleepProgress = 0.0f;
                this.sitProgress = 0.0f;
            }
        }
        if (!this.isMovementBlockedSoft() && !this.useSwimAI() && this.getAttachmentPos() == null) {
            this.field_70181_x += 0.08;
        } else if (!this.func_70631_g_()) {
            this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
        }
        if (flying && this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.getAttachmentPos() == null) {
            this.func_184185_a(FASoundRegistry.MEGANEURA_FLY, this.func_70599_aP(), 1.0f);
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 9 && this.func_70638_az() != null && this.canReachPrey()) {
            this.doAttack();
        }
    }

    private boolean isFlying() {
        return !this.field_70122_E && !this.isMovementBlockedSoft();
    }

    @Override
    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new FlightMoveHelper(this);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new EntityPrehistoricSwimming.SwimmingMoveHelper(this);
            this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    @Override
    public boolean isSleeping() {
        return false;
    }

    @Override
    public String getTexture() {
        String gender;
        String string = this.func_70631_g_() ? "_baby" : (gender = this.getGender() == 0 ? "_female" : "_male");
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + gender + ".png";
    }

    @Override
    protected boolean useSwimAI() {
        return this.func_70631_g_();
    }

    @Override
    public int getAdultAge() {
        return 9;
    }

    @Override
    public void setSpawnValues() {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.SCARED;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.FEEDING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.ATTACK;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.FLIGHT;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.IGNOREANDFISH;
    }

    @Override
    public double swimSpeed() {
        return 0.25;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151032_g;
    }

    @Override
    public float getMaleSize() {
        return 0.8f;
    }

    @Override
    public int getMaxHunger() {
        return 45;
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.MEGANEURA_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.MEGANEURA_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.MEGANEURA_DEATH;
    }

    @Override
    protected float func_70599_aP() {
        return 0.5f;
    }

    public boolean isDirectPathBetweenPoints(Vec3d target) {
        RayTraceResult rayTrace = this.field_70170_p.func_72901_a(this.func_174791_d().func_72441_c(0.0, -0.25, 0.0), target, false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(pos) || !this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            return rayTrace.field_72313_a != RayTraceResult.Type.MISS;
        }
        return true;
    }

    class AIWander
    extends EntityAIBase {
        BlockPos target;
        boolean isGoingToAttach = false;

        public AIWander() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityMeganeura.this.attachCooldown == 0) {
                for (int i = 0; i < 15; ++i) {
                    RayTraceResult rayTrace;
                    BlockPos randomPos = new BlockPos((Entity)EntityMeganeura.this).func_177982_a(EntityMeganeura.this.field_70146_Z.nextInt(16) - 8, EntityMeganeura.this.field_70146_Z.nextInt(10) - 5, EntityMeganeura.this.field_70146_Z.nextInt(16) - 8);
                    if (EntityMeganeura.this.field_70170_p.func_175623_d(randomPos) || (rayTrace = EntityMeganeura.this.field_70170_p.func_72901_a(EntityMeganeura.this.func_174791_d().func_72441_c(0.0, 0.25, 0.0), new Vec3d((Vec3i)randomPos).func_72441_c(0.5, 0.5, 0.5), false)) == null || rayTrace.field_72307_f == null || EntityMeganeura.this.field_70170_p.isSideSolid(rayTrace.func_178782_a(), rayTrace.field_178784_b)) continue;
                    this.target = rayTrace.func_178782_a();
                    this.isGoingToAttach = true;
                }
            }
            this.target = EntityMeganeura.getPositionRelativetoGround((Entity)EntityMeganeura.this, EntityMeganeura.this.field_70170_p, EntityMeganeura.this.field_70165_t + (double)EntityMeganeura.this.field_70146_Z.nextInt(16) - 8.0, EntityMeganeura.this.field_70161_v + (double)EntityMeganeura.this.field_70146_Z.nextInt(16) - 8.0, EntityMeganeura.this.field_70146_Z);
            return !EntityMeganeura.this.useSwimAI() && !EntityMeganeura.this.func_70906_o() && EntityMeganeura.this.isDirectPathBetweenPoints(new Vec3d((Vec3i)this.target).func_72441_c(0.5, 0.5, 0.5)) && EntityMeganeura.this.field_70146_Z.nextInt(4) == 0 && EntityMeganeura.this.getAttachmentPos() == null;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!EntityMeganeura.this.isDirectPathBetweenPoints(new Vec3d((Vec3i)this.target))) {
                this.target = EntityMeganeura.getPositionRelativetoGround((Entity)EntityMeganeura.this, EntityMeganeura.this.field_70170_p, EntityMeganeura.this.field_70165_t + (double)EntityMeganeura.this.field_70146_Z.nextInt(15) - 7.0, EntityMeganeura.this.field_70161_v + (double)EntityMeganeura.this.field_70146_Z.nextInt(15) - 7.0, EntityMeganeura.this.field_70146_Z);
            }
            if (EntityMeganeura.this.field_70170_p.func_175623_d(this.target) || this.isGoingToAttach) {
                if (!EntityMeganeura.this.isFlying()) {
                    EntityMeganeura.this.switchNavigator(false);
                }
                EntityMeganeura.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityMeganeura.this.func_70638_az() == null) {
                    EntityMeganeura.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class FlightMoveHelper
    extends EntityMoveHelper {
        public FlightMoveHelper(EntityMeganeura meganura) {
            super((EntityLiving)meganura);
            this.field_75645_e = 3.0;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                if (EntityMeganeura.this.field_70123_F) {
                    EntityMeganeura.this.field_70177_z += 180.0f;
                    this.field_75645_e = 0.1f;
                    BlockPos target = EntityMeganeura.getPositionRelativetoGround((Entity)EntityMeganeura.this, EntityMeganeura.this.field_70170_p, EntityMeganeura.this.field_70165_t + (double)EntityMeganeura.this.field_70146_Z.nextInt(15) - 7.0, EntityMeganeura.this.field_70161_v + (double)EntityMeganeura.this.field_70146_Z.nextInt(15) - 7.0, EntityMeganeura.this.field_70146_Z);
                    this.field_75646_b = target.func_177958_n();
                    this.field_75647_c = target.func_177956_o();
                    this.field_75644_d = target.func_177952_p();
                }
                double d0 = this.field_75646_b - EntityMeganeura.this.field_70165_t;
                double d1 = this.field_75647_c - EntityMeganeura.this.field_70163_u;
                double d2 = this.field_75644_d - EntityMeganeura.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMeganeura.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityMeganeura.this.field_70159_w *= 0.5;
                    EntityMeganeura.this.field_70181_x *= 0.5;
                    EntityMeganeura.this.field_70179_y *= 0.5;
                } else {
                    EntityMeganeura.this.field_70159_w += d0 / d3 * 0.1 * this.field_75645_e;
                    EntityMeganeura.this.field_70181_x += d1 / d3 * 0.1 * this.field_75645_e;
                    EntityMeganeura.this.field_70179_y += d2 / d3 * 0.1 * this.field_75645_e;
                    if (EntityMeganeura.this.func_70638_az() == null) {
                        EntityMeganeura.this.field_70761_aq = EntityMeganeura.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMeganeura.this.field_70159_w, (double)EntityMeganeura.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityMeganeura.this.func_70638_az().field_70165_t - EntityMeganeura.this.field_70165_t;
                        double d5 = EntityMeganeura.this.func_70638_az().field_70161_v - EntityMeganeura.this.field_70161_v;
                        EntityMeganeura.this.field_70761_aq = EntityMeganeura.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

