/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.handlers;

import drzhark.customspawner.CustomSpawner;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.type.EntitySpawnType;
import drzhark.customspawner.utils.CMSUtils;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpawnTickHandler {
    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        WorldServer world = (WorldServer)event.world;
        EnvironmentSettings environment = CMSUtils.getEnvironment((World)world);
        if (environment == null) {
            return;
        }
        for (EntitySpawnType entitySpawnType : environment.entitySpawnTypes.values()) {
            if (entitySpawnType.name().equals("UNDEFINED") || world == null || world.func_72912_H().func_82573_f() % (long)entitySpawnType.getSpawnTickRate() != 0L || !entitySpawnType.allowSpawning() || entitySpawnType.getSpawnCap() <= 0) continue;
            int spawnAmount = 0;
            if (world.field_73010_i.size() <= 0) continue;
            spawnAmount = CustomSpawner.INSTANCE.doCustomSpawning(world, entitySpawnType, entitySpawnType.getMobSpawnRange());
            if (!CustomSpawner.debug) continue;
            environment.envLog.logger.info("[" + environment.name() + "]" + "CustomSpawner Spawned " + spawnAmount + entitySpawnType.getEnumCreatureType());
        }
    }
}

