/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.api.ICustomEnchantColor;
import vazkii.quark.api.capability.IEnchantColorProvider;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.misc.item.ItemRune;

public class ColorRunes
extends Feature {
    public static final String TAG_RUNE_ATTACHED = "Quark:RuneAttached";
    public static final String TAG_RUNE_COLOR = "Quark:RuneColor";
    private static ItemStack targetStack;
    public static Item rune;
    public static int dungeonWeight;
    public static int netherFortressWeight;
    public static int jungleTempleWeight;
    public static int desertTempleWeight;
    public static int itemQuality;
    public static int applyCost;
    public static boolean enableRainbowRuneCrafting;
    public static boolean enableRainbowRuneChests;
    public static boolean stackable;

    @Override
    public void setupConfig() {
        dungeonWeight = this.loadPropInt("Dungeon loot weight", "", 20);
        netherFortressWeight = this.loadPropInt("Nether Fortress loot weight", "", 15);
        jungleTempleWeight = this.loadPropInt("Jungle Temple loot weight", "", 15);
        desertTempleWeight = this.loadPropInt("Desert Temple loot weight", "", 15);
        itemQuality = this.loadPropInt("Item quality for loot", "", 0);
        applyCost = this.loadPropInt("Cost to apply rune", "", 15);
        enableRainbowRuneCrafting = this.loadPropBool("Enable Rainbow Rune Crafting", "", true);
        enableRainbowRuneChests = this.loadPropBool("Enable Rainbow Rune in Chests", "", false);
        stackable = this.loadPropBool("Stackable Runes", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        rune = new ItemRune(stackable);
        if (enableRainbowRuneCrafting) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)rune, (int)7, (int)16), (Object[])new Object[]{"345", "2G6", "1W7", Character.valueOf('G'), ProxyRegistry.newStack((Block)Blocks.field_150359_w), Character.valueOf('W'), ProxyRegistry.newStack((Item)rune, (int)1, (int)0), Character.valueOf('1'), ProxyRegistry.newStack((Item)rune, (int)1, (int)14), Character.valueOf('2'), ProxyRegistry.newStack((Item)rune, (int)1, (int)1), Character.valueOf('3'), ProxyRegistry.newStack((Item)rune, (int)1, (int)4), Character.valueOf('4'), ProxyRegistry.newStack((Item)rune, (int)1, (int)5), Character.valueOf('5'), ProxyRegistry.newStack((Item)rune, (int)1, (int)3), Character.valueOf('6'), ProxyRegistry.newStack((Item)rune, (int)1, (int)11), Character.valueOf('7'), ProxyRegistry.newStack((Item)rune, (int)1, (int)2)});
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootFunction[] funcs = new LootFunction[]{new SetMetadata(new LootCondition[]{}, new RandomValueRange(0.0f, enableRainbowRuneChests ? 16.0f : 15.0f))};
        if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(rune, dungeonWeight, itemQuality, funcs, new LootCondition[0], "quark:rune"));
        } else if (event.getName().equals((Object)LootTableList.field_186425_g)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(rune, netherFortressWeight, itemQuality, funcs, new LootCondition[0], "quark:rune"));
        } else if (event.getName().equals((Object)LootTableList.field_186430_l)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(rune, jungleTempleWeight, itemQuality, funcs, new LootCondition[0], "quark:rune"));
        } else if (event.getName().equals((Object)LootTableList.field_186429_k)) {
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(rune, desertTempleWeight, itemQuality, funcs, new LootCondition[0], "quark:rune"));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.func_190926_b() && !right.func_190926_b() && left.func_77948_v() && right.func_77973_b() == rune) {
            ItemStack out = left.func_77946_l();
            ItemNBTHelper.setBoolean((ItemStack)out, (String)TAG_RUNE_ATTACHED, (boolean)true);
            ItemNBTHelper.setInt((ItemStack)out, (String)TAG_RUNE_COLOR, (int)right.func_77952_i());
            event.setOutput(out);
            event.setCost(applyCost);
            event.setMaterialCost(1);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static void setTargetStack(ItemStack stack) {
        targetStack = stack;
    }

    public static void setTargetStack(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ColorRunes.setTargetStack(entity.func_184582_a(slot));
    }

    public static int getColor(int original) {
        if (!ModuleLoader.isFeatureEnabled(ColorRunes.class) || !ColorRunes.doesStackHaveRune(targetStack) && !targetStack.func_190926_b() && !(targetStack.func_77973_b() instanceof ICustomEnchantColor)) {
            return original;
        }
        return ColorRunes.getColorFromStack(targetStack);
    }

    public static void applyColor() {
        if (!ModuleLoader.isFeatureEnabled(ColorRunes.class) || !ColorRunes.doesStackHaveRune(targetStack)) {
            return;
        }
        int color = ColorRunes.getColorFromStack(targetStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static int getColorFromStack(ItemStack stack) {
        int b;
        int g;
        int r;
        int t;
        if (stack.func_190926_b()) {
            return 0xFFFFFF;
        }
        int retColor = 0xFFFFFF;
        boolean truncate = true;
        if (IEnchantColorProvider.hasProvider(stack)) {
            IEnchantColorProvider provider = IEnchantColorProvider.getProvider(stack);
            int color = provider.getEnchantEffectColor();
            truncate = provider.shouldTruncateColorBrightness();
            retColor = 0xFF000000 | color;
        } else if (ColorRunes.doesStackHaveRune(stack)) {
            int color = ItemRune.getColor(ItemNBTHelper.getInt((ItemStack)targetStack, (String)TAG_RUNE_COLOR, (int)0));
            retColor = 0xFF000000 | color;
        }
        if (truncate && (t = (r = retColor >> 16 & 0xFF) + (g = retColor >> 8 & 0xFF) + (b = retColor & 0xFF)) > 396) {
            float mul = 396.0f / (float)t;
            r = (int)((float)r * mul);
            g = (int)((float)g * mul);
            b = (int)((float)b * mul);
            retColor = -16777216 + (r << 16) + (g << 8) + b;
        }
        return retColor;
    }

    public static boolean doesStackHaveRune(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_RUNE_ATTACHED, (boolean)false);
    }
}

