/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.api.capability.IBoatBanner;
import vazkii.quark.base.capability.BackedUpBoatBanner;
import vazkii.quark.base.capability.SimpleProvider;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageSyncBoatBanner;
import vazkii.quark.base.sounds.QuarkSounds;

public class BoatSails
extends Feature {
    private static final String TAG_BANNER = "quark:banner";
    private static final ResourceLocation BANNER_CAPABILITY = new ResourceLocation("quark:banner");
    private static final WeakHashMap<EntityBoat, ItemStack> cachedStacks = new WeakHashMap();
    private static final TIntObjectHashMap<ItemStack> uninitializedStacks = new TIntObjectHashMap();

    public static void setBanner(Entity entity, ItemStack banner, boolean sync) {
        EntityBoat boat;
        ItemStack cached;
        if (!(!BoatSails.canHaveBanner(entity) || (cached = cachedStacks.get(boat = (EntityBoat)entity)) != null && sync && ItemStack.func_77989_b((ItemStack)banner, (ItemStack)cached))) {
            IBoatBanner.getBoatBanner((Entity)boat).setStack(banner);
            if (sync) {
                cachedStacks.put(boat, banner);
                if (boat.field_70170_p instanceof WorldServer) {
                    WorldServer world = (WorldServer)boat.field_70170_p;
                    for (EntityPlayer target : world.func_73039_n().getTrackingPlayers((Entity)boat)) {
                        BoatSails.syncDataFor((Entity)boat, target);
                    }
                }
            }
        }
    }

    private static void syncDataFor(Entity target, EntityPlayer player) {
        if (player instanceof EntityPlayerMP && BoatSails.canHaveBanner(target)) {
            ItemStack banner = BoatSails.getBanner(target);
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncBoatBanner(target.func_145782_y(), banner), (EntityPlayerMP)player);
        }
    }

    public static void queueBannerUpdate(int boatID, ItemStack banner) {
        uninitializedStacks.put(boatID, (Object)banner);
    }

    @SubscribeEvent
    public void onBoatGenesis(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityBoat) {
            event.addCapability(BANNER_CAPABILITY, new SimpleProvider<BackedUpBoatBanner>(IBoatBanner.CAPABILITY, new BackedUpBoatBanner((EntityBoat)event.getObject())));
        }
    }

    @SubscribeEvent
    public void onBoatSeen(PlayerEvent.StartTracking event) {
        BoatSails.syncDataFor(event.getTarget(), event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onBoatArrive(EntityJoinWorldEvent event) {
        Entity target;
        int id;
        if (event.getWorld().field_72995_K && uninitializedStacks.containsKey(id = (target = event.getEntity()).func_145782_y())) {
            BoatSails.setBanner(target, (ItemStack)uninitializedStacks.get(id), false);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (BoatSails.canHaveBanner(target) && !target.func_184188_bt().contains(player)) {
            ItemStack banner = BoatSails.getBanner(target);
            if (!banner.func_190926_b()) {
                return;
            }
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBanner)) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBanner) {
                ItemStack copyStack = stack.func_77946_l();
                player.func_184609_a(hand);
                BoatSails.setBanner(target, copyStack, !event.getWorld().field_72995_K);
                if (!event.getWorld().field_72995_K) {
                    event.getWorld().func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, QuarkSounds.ENTITY_BOAT_ADD_ITEM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    public static void onBoatUpdate(Entity boat) {
        if (!ModuleLoader.isFeatureEnabled(BoatSails.class) || !BoatSails.canHaveBanner(boat)) {
            return;
        }
        if (!boat.field_70170_p.field_72995_K) {
            BoatSails.setBanner(boat, BoatSails.getBanner(boat), true);
        }
    }

    public static boolean canHaveBanner(Entity target) {
        return target instanceof EntityBoat && IBoatBanner.hasBoatBanner(target);
    }

    public static ItemStack getBanner(Entity target) {
        return IBoatBanner.getBoatBanner(target).getStack();
    }

    public static void dropBoatBanner(EntityBoat boat) {
        if (!ModuleLoader.isFeatureEnabled(BoatSails.class)) {
            return;
        }
        ItemStack banner = BoatSails.getBanner((Entity)boat);
        if (!banner.func_190926_b()) {
            banner.func_190920_e(1);
            boat.func_70099_a(banner, 0.0f);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

