/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.entity.EntityThrowableItem;
import com.mrcrayfish.guns.init.ModGuns;
import com.mrcrayfish.guns.world.ProjectileExplosion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityThrowableGrenade
extends EntityThrowableItem {
    public float rotation;
    public float prevRotation;

    public EntityThrowableGrenade(World worldIn) {
        super(worldIn);
    }

    public EntityThrowableGrenade(World world, EntityPlayer player) {
        super(world, player);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((Item)ModGuns.GRENADE));
        this.setMaxLife(60);
        this.func_70105_a(0.25f, 0.25f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevRotation = this.rotation;
        float speed = (float)Math.sqrt(Math.pow(this.field_70159_w, 2.0) + Math.pow(this.field_70181_x, 2.0) + Math.pow(this.field_70179_y, 2.0));
        if ((double)speed > 0.1) {
            this.rotation += speed * 50.0f;
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0, 0.0, 0.0, new int[]{10});
    }

    @Override
    public void onDeath() {
        EntityThrowableGrenade.createGrenadeExplosion(this, (Entity)this.thrower, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false, true);
    }

    private static void createGrenadeExplosion(EntityThrowableGrenade grenade, Entity thrower, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        boolean canGunGrief = grenade.field_70170_p.func_82736_K().func_82766_b("gunGriefing");
        ProjectileExplosion explosion = new ProjectileExplosion(grenade.field_70170_p, thrower, grenade, grenade.getItem(), x, y, z, ModGuns.GRENADE_LAUNCHER.getGun().projectile.damage, GunConfig.SERVER.grenades.explosionRadius, canGunGrief);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        explosion.func_180342_d();
        if (grenade.field_70170_p instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)grenade.field_70170_p;
            worldServer.func_180505_a(EnumParticleTypes.EXPLOSION_HUGE, true, x, y, z, 0, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

