/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractRenderVehicle<T extends EntityVehicle> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};

    public abstract void render(T var1, float var2);

    public void applyPlayerModel(T entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
    }

    public void applyPlayerRender(T entity, EntityPlayer player, float partialTicks) {
    }

    protected boolean shouldRenderFuelLid() {
        return true;
    }

    protected void renderDamagedPart(EntityVehicle vehicle, IBakedModel model) {
        this.renderDamagedPart(vehicle, model, false);
        this.renderDamagedPart(vehicle, model, true);
    }

    private void renderDamagedPart(EntityVehicle vehicle, IBakedModel model, boolean renderDamage) {
        if (renderDamage) {
            int stage = vehicle.getDestroyedStage();
            if (stage <= 0) {
                return;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(DESTROY_STAGES[stage - 1]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179152_a((float)64.0f, (float)32.0f, (float)32.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0015f, (float)1.0E-4f);
            GlStateManager.func_179152_a((float)1.0025f, (float)1.0025f, (float)1.0025f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
            if (!model.func_188618_c()) {
                RenderUtil.renderModel(model, vehicle.getColor());
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        } else {
            RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, vehicle.getColor());
        }
    }

    public SpecialModels getTowBarModel() {
        return SpecialModels.TOW_BAR;
    }
}

