/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class IEExplosion
extends Explosion {
    public float dropChance = 1.0f / this.field_77280_f;
    private int blockDestroyInt = 0;
    public int blocksPerTick = 8;
    public boolean isExplosionFinished = false;

    public IEExplosion(World world, Entity igniter, double x, double y, double z, float size, boolean isFlaming, boolean isSmoking) {
        super(world, igniter, x, y, z, size, isFlaming, isSmoking);
    }

    public IEExplosion setDropChance(float chance) {
        this.dropChance = chance;
        return this;
    }

    public void doExplosionTick() {
        int max = Math.min(this.blockDestroyInt + this.blocksPerTick, this.field_77281_g.size());
        while (this.blockDestroyInt < max) {
            BlockPos pos = (BlockPos)this.field_77281_g.get(this.blockDestroyInt);
            IBlockState state = this.field_77287_j.func_180495_p(pos);
            Block block = state.func_177230_c();
            double d0 = (float)pos.func_177958_n() + Utils.RAND.nextFloat();
            double d1 = (float)pos.func_177956_o() + Utils.RAND.nextFloat();
            double d2 = (float)pos.func_177952_p() + Utils.RAND.nextFloat();
            double d3 = d0 - this.field_77284_b;
            double d4 = d1 - this.field_77285_c;
            double d5 = d2 - this.field_77282_d;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.field_77284_b * 1.0) / 2.0, (d1 + this.field_77285_c * 1.0) / 2.0, (d2 + this.field_77282_d * 1.0) / 2.0, d3 *= (d7 *= (double)(Utils.RAND.nextFloat() * Utils.RAND.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
            this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            if (state.func_185904_a() != Material.field_151579_a) {
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.field_77287_j, pos, this.field_77287_j.func_180495_p(pos), this.dropChance, 0);
                }
                block.onBlockExploded(this.field_77287_j, pos, (Explosion)this);
            }
            ++this.blockDestroyInt;
        }
        if (this.blockDestroyInt >= this.field_77281_g.size()) {
            this.isExplosionFinished = true;
        }
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d6 = this.field_77285_c;
                    double d8 = this.field_77282_d;
                    float f1 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + Utils.RAND.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.field_77287_j, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.field_77287_j, blockpos, null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.field_77287_j, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        Collections.sort(this.field_77281_g, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos arg0, BlockPos arg1) {
                return Double.compare(arg0.func_177954_c(IEExplosion.this.field_77284_b, IEExplosion.this.field_77285_c, IEExplosion.this.field_77282_d), arg1.func_177954_c(IEExplosion.this.field_77284_b, IEExplosion.this.field_77285_c, IEExplosion.this.field_77282_d));
            }
        });
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3 = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.field_77287_j.func_72842_a(vec3, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = entity instanceof EntityLivingBase ? EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10) : d10;
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75102_a) continue;
            this.field_77288_k.put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.field_77287_j.func_184134_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 4.0f, (1.0f + (Utils.RAND.nextFloat() - Utils.RAND.nextFloat()) * 0.2f) * 0.7f, true);
        if (this.field_77280_f >= 2.0f && this.field_82755_b) {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        }
        EventHandler.currentExplosions.add(this);
    }
}

