/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace;

import blusunrize.immersiveengineering.common.util.Utils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlastFurnaceFuelWrapper
implements IRecipeWrapper {
    private final List<ItemStack> fuel;
    private static final String S_BURNTIME = I18n.func_135052_a((String)"desc.immersiveengineering.info.blastFuelTime", (Object[])new Object[0]);
    private final String burnTime;
    private final IDrawableAnimated flame;

    public BlastFurnaceFuelWrapper(IGuiHelper guiHelper, List<ItemStack> fuel, int burnTime) {
        this.fuel = fuel;
        this.burnTime = I18n.func_135052_a((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble((float)burnTime / 20.0f, "0.##")});
        ResourceLocation furnaceBackgroundLocation = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        IDrawableStatic flameDrawable = guiHelper.createDrawable(furnaceBackgroundLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, burnTime, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.fuel);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(S_BURNTIME, 24, 8, Color.gray.getRGB());
        minecraft.field_71466_p.func_78276_b(this.burnTime, 24, 18, Color.gray.getRGB());
    }
}

