/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.client;

import com.google.common.collect.Maps;
import fossilsarcheology.client.event.FossilClientPlayerEvent;
import fossilsarcheology.client.event.FossilHelmetOverlayEvent;
import fossilsarcheology.client.event.FossilMainMenuEvent;
import fossilsarcheology.client.event.FossilTarOverlayEvent;
import fossilsarcheology.client.gui.AnalyzerGUI;
import fossilsarcheology.client.gui.CultivateGUI;
import fossilsarcheology.client.gui.FeederGUI;
import fossilsarcheology.client.gui.SifterGUI;
import fossilsarcheology.client.gui.TimeMachineGUI;
import fossilsarcheology.client.gui.WorktableGUI;
import fossilsarcheology.client.gui.dinopedia.GuiPedia;
import fossilsarcheology.client.model.ModelAncientHelmet;
import fossilsarcheology.client.particle.BubbleFX;
import fossilsarcheology.client.particle.ParticleTarBubble;
import fossilsarcheology.client.render.FATEISR;
import fossilsarcheology.client.render.RenderingHandler;
import fossilsarcheology.server.ServerProxy;
import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.api.IgnoreRenderProperty;
import fossilsarcheology.server.api.SubtypeRenderedItem;
import fossilsarcheology.server.block.EnumFossilPlant;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.FigurineBlock;
import fossilsarcheology.server.block.FossilDoorBlock;
import fossilsarcheology.server.block.FossilFenceGateBlock;
import fossilsarcheology.server.block.VaseBlock;
import fossilsarcheology.server.block.entity.TileEntityAnalyzer;
import fossilsarcheology.server.block.entity.TileEntityCultivate;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.block.entity.TileEntitySifter;
import fossilsarcheology.server.block.entity.TileEntityTimeMachine;
import fossilsarcheology.server.block.entity.TileEntityWorktable;
import fossilsarcheology.server.compat.tinkers.TinkersCompatBridge;
import fossilsarcheology.server.container.CultivateContainer;
import fossilsarcheology.server.entity.EntityFishBase;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ClientProxy
extends ServerProxy {
    @SideOnly(value=Side.CLIENT)
    public static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    @SideOnly(value=Side.CLIENT)
    public static final RenderingHandler RENDER_HANDLER = new RenderingHandler();
    @SideOnly(value=Side.CLIENT)
    private static final FATEISR TEISR = new FATEISR();
    @SideOnly(value=Side.CLIENT)
    private static final ModelAncientHelmet helmetModel = new ModelAncientHelmet(0.45f);
    private static final ModelResourceLocation BLOCK_TAR_MODEL = new ModelResourceLocation("fossil:tar", "fluid");
    private static final Map<String, ISound> CURRENTLY_PLAYING_SOUNDS = Maps.newHashMap();

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        void var2_13;
        void var2_11;
        void var2_9;
        void var2_7;
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.VOLUTE_VASE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{VaseBlock.VARIANT}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.AMPHORA_VASE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{VaseBlock.VARIANT}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.KYLIX_VASE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{VaseBlock.VARIANT}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.FIGURINE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FigurineBlock.VARIANT}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.PALM_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.PALM_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilFenceGateBlock.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.PALM_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilDoorBlock.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CALAMITES_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CALAMITES_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilFenceGateBlock.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CALAMITES_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilDoorBlock.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.SIGILLARIA_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.SIGILLARIA_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilFenceGateBlock.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.SIGILLARIA_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilDoorBlock.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CORDAITES_LEAVES, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CORDAITES_FENCE_GATE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilFenceGateBlock.field_176465_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.CORDAITES_DOOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{FossilDoorBlock.field_176522_N}).func_178441_a());
        for (Block block : FABlockRegistry.BLOCKS) {
            if (!(block instanceof IgnoreRenderProperty)) continue;
            IProperty<?>[] ignoredProperties = ((IgnoreRenderProperty)block).getIgnoredProperties();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(ignoredProperties).func_178441_a());
        }
        for (Block block : FABlockRegistry.BLOCKS) {
            int[] subtypes;
            if (block instanceof DefaultRenderedItem) {
                RENDER_HANDLER.registerBlockRenderer(block, ((DefaultRenderedItem)block).getResource(block.getRegistryName()), "inventory");
                continue;
            }
            if (!(block instanceof SubtypeRenderedItem)) continue;
            SubtypeRenderedItem subtypeItem = (SubtypeRenderedItem)block;
            for (int metadata : subtypes = subtypeItem.getUsedSubtypes()) {
                RENDER_HANDLER.registerBlockRenderer(block, metadata, subtypeItem.getResource(block.getRegistryName(), metadata), "inventory");
            }
        }
        Item tar = Item.func_150898_a((Block)FABlockRegistry.TAR);
        ModelBakery.registerItemVariants((Item)tar, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)tar, stack -> BLOCK_TAR_MODEL);
        ModelLoader.setCustomStateMapper((Block)FABlockRegistry.TAR, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return BLOCK_TAR_MODEL;
            }
        });
        for (Item item : FAItemRegistry.ITEMS) {
            int[] subtypes;
            if (item instanceof DefaultRenderedItem) {
                String resource = ((DefaultRenderedItem)item).getResource(item.getRegistryName());
                RENDER_HANDLER.registerItemRenderer(item, resource, "inventory");
                continue;
            }
            if (!(item instanceof SubtypeRenderedItem)) continue;
            SubtypeRenderedItem subtypeItem = (SubtypeRenderedItem)item;
            for (int metadata : subtypes = subtypeItem.getUsedSubtypes()) {
                RENDER_HANDLER.registerItemRenderer(item, metadata, subtypeItem.getResource(item.getRegistryName(), metadata), "inventory");
            }
        }
        boolean bl = false;
        while (var2_7 < 16) {
            RENDER_HANDLER.registerItemRenderer(FAItemRegistry.TOY_BALL, (int)var2_7, "toyball_" + EnumDyeColor.func_176766_a((int)var2_7).func_176610_l(), "inventory");
            ++var2_7;
        }
        boolean bl2 = false;
        while (var2_9 < 16) {
            RENDER_HANDLER.registerItemRenderer(Item.func_150898_a((Block)FABlockRegistry.FIGURINE), (int)var2_9, "figurine_" + (int)var2_9, "inventory");
            ++var2_9;
        }
        boolean bl3 = false;
        while (var2_11 < EnumFossilPlant.values().length) {
            RENDER_HANDLER.registerItemRenderer(FAItemRegistry.FOSSIL_SEED, (int)var2_11, "fossil_seed_" + (Object)((Object)EnumFossilPlant.values()[var2_11]), "inventory");
            RENDER_HANDLER.registerItemRenderer(FAItemRegistry.SEED, (int)var2_11, "seed_" + (Object)((Object)EnumFossilPlant.values()[var2_11]), "inventory");
            ++var2_11;
        }
        boolean bl4 = false;
        while (var2_13 < 5) {
            RENDER_HANDLER.registerItemRenderer(Item.func_150898_a((Block)FABlockRegistry.AMPHORA_VASE), (int)var2_13, "vase_amphora_" + (int)var2_13, "inventory");
            RENDER_HANDLER.registerItemRenderer(Item.func_150898_a((Block)FABlockRegistry.KYLIX_VASE), (int)var2_13, "vase_kylix_" + (int)var2_13, "inventory");
            RENDER_HANDLER.registerItemRenderer(Item.func_150898_a((Block)FABlockRegistry.VOLUTE_VASE), (int)var2_13, "vase_volute_" + (int)var2_13, "inventory");
            ++var2_13;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPreInit() {
        super.onPreInit();
        OBJLoader.INSTANCE.addDomain("fossil");
        RENDER_HANDLER.onPreInit();
        TinkersCompatBridge.loadTinkersClientCompat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInit() {
        super.onInit();
        MinecraftForge.EVENT_BUS.register((Object)new FossilClientPlayerEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FossilMainMenuEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FossilTarOverlayEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FossilHelmetOverlayEvent());
        RENDER_HANDLER.onInit();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPostInit() {
        super.onPostInit();
        RENDER_HANDLER.onPostInit();
        Item.func_150898_a((Block)FABlockRegistry.ANUBITE_STATUE).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)TEISR);
        Item.func_150898_a((Block)FABlockRegistry.ANU_STATUE).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)TEISR);
        Item.func_150898_a((Block)FABlockRegistry.SARCOPHAGUS).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)TEISR);
        Item.func_150898_a((Block)FABlockRegistry.ANCIENT_CHEST).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)TEISR);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void calculateChainBuffer(EntityFishBase entity) {
        entity.chainBuffer.calculateChainSwingBuffer(70.0f, 10, 4.0f, (EntityLivingBase)entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity entity = world.func_175625_s(pos);
        if (id == 0 && entity instanceof TileEntityAnalyzer) {
            return new AnalyzerGUI(player.field_71071_by, (TileEntityAnalyzer)entity);
        }
        if (id == 1 && entity instanceof TileEntityCultivate) {
            return new CultivateGUI((TileEntityCultivate)entity, new CultivateContainer(player.field_71071_by, (TileEntityCultivate)entity));
        }
        if (id == 2 && entity instanceof TileEntityFeeder) {
            return new FeederGUI(player.field_71071_by, (TileEntityFeeder)entity);
        }
        if (id == 3 && entity instanceof TileEntityWorktable) {
            return new WorktableGUI(player.field_71071_by, (TileEntityWorktable)entity);
        }
        if (id == 4 && entity instanceof TileEntitySifter) {
            return new SifterGUI(player.field_71071_by, (TileEntitySifter)entity);
        }
        if (id == 5 && entity instanceof TileEntityTimeMachine) {
            return new TimeMachineGUI(player.field_71071_by, (TileEntityTimeMachine)entity);
        }
        if (id == 6) {
            return new GuiPedia();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnBubbleParticles(World world, float f, float f1, float f2, double motionX, double motionY, double motionZ) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new BubbleFX(world, f, f1, f2, motionX, motionY, motionZ));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnFAParticle(String type, float posX, float posY, float posZ, double motionX, double motionY, double motionZ) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (type.equals("tar_bubble")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTarBubble((World)world, posX, posY, posZ, motionX, motionY, motionZ));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(int id) {
        return id == 0 ? helmetModel : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playSound(SoundEvent sound) {
        ISound sounds = CURRENTLY_PLAYING_SOUNDS.get(sound.func_187503_a().toString());
        if (sounds == null) {
            sounds = PositionedSoundRecord.func_184370_a((SoundEvent)sound);
            CURRENTLY_PLAYING_SOUNDS.put(sound.func_187503_a().toString(), sounds);
        }
        if (!Minecraft.func_71410_x().func_147118_V().func_147692_c(sounds)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a(sounds);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void stopSound(SoundEvent sound) {
        ISound sounds = CURRENTLY_PLAYING_SOUNDS.get(sound.func_187503_a().toString());
        if (sounds == null) {
            sounds = PositionedSoundRecord.func_184370_a((SoundEvent)sound);
            CURRENTLY_PLAYING_SOUNDS.put(sound.func_187503_a().toString(), sounds);
        }
        if (Minecraft.func_71410_x().func_147118_V().func_147692_c(sounds)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(sounds);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openPedia() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPedia());
    }
}

