/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.client.render.entity;

import fossilsarcheology.server.entity.StoneTabletEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class StoneTabletRenderer
extends Render<StoneTabletEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("fossil", "textures/entities/stone_tablet.png");

    public StoneTabletRenderer(RenderManager renderManager) {
        super(renderManager);
    }

    private void renderTablet(StoneTabletEntity entity, int width, int height, int textureU, int textureV) {
        float xOffset = (float)(-width) / 2.0f;
        float yOffset = (float)(-height) / 2.0f;
        for (int blockX = 0; blockX < width / 16; ++blockX) {
            for (int blockZ = 0; blockZ < height / 16; ++blockZ) {
                float maxX = xOffset + (float)((blockX + 1) * 16);
                float minX = xOffset + (float)(blockX * 16);
                float maxY = yOffset + (float)((blockZ + 1) * 16);
                float minY = yOffset + (float)(blockZ * 16);
                this.setLightmap(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float minTexX = (float)(textureU + width - blockX * 16) / 256.0f;
                float maxTexX = (float)(textureU + width - (blockX + 1) * 16) / 256.0f;
                float minTexY = (float)(textureV + height - blockZ * 16) / 256.0f;
                float maxTexY = (float)(textureV + height - (blockZ + 1) * 16) / 256.0f;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                builder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                builder.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a((double)maxTexX, (double)minTexY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a((double)minTexX, (double)minTexY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a((double)minTexX, (double)maxTexY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a((double)maxTexX, (double)maxTexY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a(0.75, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a(0.8125, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a(0.8125, 0.0625).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a(0.75, 0.0625).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a(0.75, 0.001953125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a(0.8125, 0.001953125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a(0.8125, 0.001953125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a(0.75, 0.001953125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a(0.75, 0.001953125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a(0.8125, 0.001953125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a(0.8125, 0.001953125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a(0.75, 0.001953125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a(0.751953125, 0.0).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a(0.751953125, 0.0625).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a(0.751953125, 0.0625).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a(0.751953125, 0.0).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a(0.751953125, 0.0).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a(0.751953125, 0.0625).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a(0.751953125, 0.0625).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                builder.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a(0.751953125, 0.0).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    private void setLightmap(StoneTabletEntity entity, float centerX, float centerY) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)(entity.field_70163_u + (double)(centerY / 16.0f)));
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        EnumFacing facing = entity.field_174860_b;
        if (facing == EnumFacing.NORTH) {
            x = MathHelper.func_76128_c((double)(entity.field_70165_t + (double)(centerX / 16.0f)));
        } else if (facing == EnumFacing.WEST) {
            z = MathHelper.func_76128_c((double)(entity.field_70161_v - (double)(centerX / 16.0f)));
        } else if (facing == EnumFacing.SOUTH) {
            x = MathHelper.func_76128_c((double)(entity.field_70165_t - (double)(centerX / 16.0f)));
        } else if (facing == EnumFacing.EAST) {
            z = MathHelper.func_76128_c((double)(entity.field_70161_v + (double)(centerX / 16.0f)));
        }
        int combinedLight = this.field_76990_c.field_78722_g.func_175626_b(new BlockPos(x, y, z), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(combinedLight % 65536), (float)(combinedLight / 65536));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void doRender(StoneTabletEntity entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        this.func_180548_c((Entity)entity);
        StoneTabletEntity.Variant variant = entity.variant;
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.renderTablet(entity, variant.sizeX, variant.sizeY, variant.offsetX, variant.offsetY);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(StoneTabletEntity entity) {
        return TEXTURE;
    }
}

