/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.structure;

import fossilsarcheology.server.structure.FABlockProcessorAnu;
import fossilsarcheology.server.structure.FABlockProcessorLoot;
import fossilsarcheology.server.world.FAWorldGenerator;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureUtils {
    public static boolean generateStructureAtWithRandomRotation(ResourceLocation structure, World world, BlockPos pos, Random random, boolean checkGround, boolean removeAir) {
        EnumFacing facing = EnumFacing.func_176731_b((int)random.nextInt(3));
        Rotation rotation = StructureUtils.getRotationFromFacing(facing);
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        if (removeAir) {
            settings.func_186225_a(Blocks.field_150350_a);
        }
        Template template = templateManager.func_186237_a(server, structure);
        BlockPos center = StructureUtils.balancePos(pos.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2), template.func_186259_a());
        template.func_186260_a(world, center, settings);
        return true;
    }

    public static boolean canGenOnBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        if (!state.func_185914_p()) {
            return false;
        }
        return !world.func_180495_p(pos.func_177984_a()).func_185914_p() && !(world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof BlockLiquid);
    }

    public static boolean generateStructureAt(ResourceLocation structure, World world, BlockPos pos, boolean removeAir) {
        EnumFacing facing = EnumFacing.NORTH;
        Rotation rotation = StructureUtils.getRotationFromFacing(facing);
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        if (removeAir) {
            settings.func_186225_a(Blocks.field_150350_a);
        }
        Template template = templateManager.func_186237_a(server, structure);
        BlockPos center = pos.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        template.func_186260_a(world, center, settings);
        return true;
    }

    private static BlockPos balancePos(BlockPos center, BlockPos templateSize) {
        BlockPos heightNE = center.func_177967_a(EnumFacing.NORTH, templateSize.func_177952_p() / 2).func_177967_a(EnumFacing.EAST, templateSize.func_177952_p() / 2);
        BlockPos heightNW = center.func_177967_a(EnumFacing.NORTH, templateSize.func_177952_p() / 2).func_177967_a(EnumFacing.WEST, templateSize.func_177952_p() / 2);
        BlockPos heightSE = center.func_177967_a(EnumFacing.SOUTH, templateSize.func_177952_p() / 2).func_177967_a(EnumFacing.EAST, templateSize.func_177952_p() / 2);
        BlockPos heightSW = center.func_177967_a(EnumFacing.SOUTH, templateSize.func_177952_p() / 2).func_177967_a(EnumFacing.WEST, templateSize.func_177952_p() / 2);
        int averageHeight = (heightNE.func_177956_o() + heightNW.func_177956_o() + heightSE.func_177956_o() + heightSW.func_177956_o()) / 4 + 1;
        return new BlockPos(center.func_177958_n(), averageHeight, center.func_177952_p());
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static void generateStructureAtWithRandomRotationWithLoot(ResourceLocation structure, ResourceLocation loot, World world, BlockPos pos, Random random, boolean checkGround, boolean removeAir) {
        EnumFacing facing = EnumFacing.func_176731_b((int)random.nextInt(3));
        Rotation rotation = StructureUtils.getRotationFromFacing(facing);
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        if (removeAir) {
            settings.func_186225_a(Blocks.field_150350_a);
        }
        Template template = templateManager.func_186237_a(server, structure);
        BlockPos center = StructureUtils.balancePos(pos.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2), template.func_186259_a());
        template.func_189960_a(world, center, (ITemplateProcessor)new FABlockProcessorLoot(center, settings, loot), settings, 2);
    }

    public static boolean generateStructureAtWithRotation(ResourceLocation structure, World world, BlockPos pos, Random random, Rotation rotation, boolean checkGround, boolean removeAir) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        if (removeAir) {
            settings.func_186225_a(Blocks.field_150350_a);
        }
        Template template = templateManager.func_186237_a(server, structure);
        BlockPos center = pos;
        switch (rotation) {
            case NONE: {
                center = pos;
                break;
            }
            case CLOCKWISE_90: {
                center = pos.func_177982_a(template.func_186259_a().func_177952_p() - 1, 0, 0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                center = pos.func_177982_a(0, 0, template.func_186259_a().func_177958_n() - 1);
                break;
            }
            case CLOCKWISE_180: {
                center = pos.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
            }
        }
        if (checkGround) {
            BlockPos corner1 = pos.func_177977_b();
            BlockPos corner2 = pos.func_177982_a(template.func_186259_a().func_177958_n(), -1, 0);
            BlockPos corner3 = pos.func_177982_a(template.func_186259_a().func_177958_n(), -1, template.func_186259_a().func_177952_p());
            BlockPos corner4 = pos.func_177982_a(0, -1, template.func_186259_a().func_177952_p());
            if (world.func_180495_p(center).func_185914_p() && world.func_180495_p(corner1).func_185914_p() && world.func_180495_p(corner2).func_185914_p() && world.func_180495_p(corner3).func_185914_p() && world.func_180495_p(corner4).func_185914_p()) {
                template.func_186260_a(world, center, settings);
                return true;
            }
            return false;
        }
        template.func_186260_a(world, center, settings);
        return true;
    }

    public static boolean generateStructureAtWithRotationWithLoot(ResourceLocation structure, ResourceLocation loot, World world, BlockPos pos, Random random, Rotation rotation, boolean checkGround, boolean removeAir) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE);
        if (removeAir) {
            settings.func_186225_a(Blocks.field_150350_a);
        }
        Template template = templateManager.func_186237_a(server, structure);
        BlockPos center = pos.func_177982_a(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2);
        if (checkGround) {
            BlockPos corner1 = pos.func_177977_b();
            BlockPos corner2 = pos.func_177982_a(template.func_186259_a().func_177958_n(), -1, 0);
            BlockPos corner3 = pos.func_177982_a(template.func_186259_a().func_177958_n(), -1, template.func_186259_a().func_177952_p());
            BlockPos corner4 = pos.func_177982_a(0, -1, template.func_186259_a().func_177952_p());
            if (world.func_180495_p(center).func_185914_p() && world.func_180495_p(corner1).func_185914_p() && world.func_180495_p(corner2).func_185914_p() && world.func_180495_p(corner3).func_185914_p() && world.func_180495_p(corner4).func_185914_p()) {
                template.func_189960_a(world, center, (ITemplateProcessor)(structure == FAWorldGenerator.ANU_CASTLE ? new FABlockProcessorAnu(center, settings, loot) : new FABlockProcessorLoot(center, settings, loot)), settings, 2);
                return true;
            }
            return false;
        }
        template.func_189960_a(world, center, (ITemplateProcessor)(structure == FAWorldGenerator.ANU_CASTLE ? new FABlockProcessorAnu(center, settings, loot) : new FABlockProcessorLoot(center, settings, loot)), settings, 2);
        return true;
    }

    public static BlockPos getGround(BlockPos pos, World world) {
        return StructureUtils.getGround(pos.func_177958_n(), pos.func_177952_p(), world);
    }

    public static BlockPos getGround(int x, int z, World world) {
        BlockPos skyPos = new BlockPos(x, world.func_72800_K(), z);
        while ((!world.func_180495_p(skyPos).func_185914_p() || StructureUtils.canHeightSkipBlock(skyPos, world)) && skyPos.func_177956_o() > 1) {
            skyPos = skyPos.func_177977_b();
        }
        return skyPos;
    }

    private static boolean canHeightSkipBlock(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLog || state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockLiquid;
    }
}

