/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.google.common.base.Optional;
import de.maxhenkel.camera.ModItems;
import de.maxhenkel.camera.items.ItemImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityImage
extends Entity {
    private static final DataParameter<Optional<UUID>> ID = EntityDataManager.func_187226_a(EntityImage.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<EnumFacing> FACING = EntityDataManager.func_187226_a(EntityImage.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Integer> WIDTH = EntityDataManager.func_187226_a(EntityImage.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEIGHT = EntityDataManager.func_187226_a(EntityImage.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityImage.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final AxisAlignedBB NULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double THICKNESS = 0.0625;
    private static final int MAX_WIDTH = 12;
    private static final int MAX_HEIGHT = 12;
    private AxisAlignedBB boundingBox;

    public EntityImage(World world) {
        super(world);
        this.field_70130_N = 1.0f;
        this.field_70131_O = 1.0f;
        this.boundingBox = NULL_AABB;
    }

    public void func_70071_h_() {
        this.updateBoundingBox();
        super.func_70071_h_();
        this.checkValid();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && player.field_71075_bZ.field_75099_e) {
            player.openGui((Object)"camera", 2, player.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasImage()) {
            if (stack.func_190926_b()) {
                ItemStack containedItem = this.removeImage();
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184611_a(hand, containedItem);
                    this.playRemoveSound();
                }
            } else {
                ItemStack image = this.removeImage();
                if (!this.field_70170_p.field_72995_K) {
                    this.playRemoveSound();
                    if (!player.func_191521_c(image)) {
                        this.dropItem(image);
                    }
                }
            }
        }
        if (stack.func_77973_b().equals((Object)ModItems.IMAGE)) {
            UUID uuid = ItemImage.getUUID(stack);
            if (uuid == null) {
                return true;
            }
            ItemStack frameStack = stack.func_77979_a(1);
            this.setItem(frameStack);
            this.setUUID(uuid);
            player.func_184611_a(hand, stack);
            this.playAddSound();
            return true;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!(source.func_76364_f() instanceof EntityPlayer)) {
            return false;
        }
        if (!((EntityPlayer)source.func_76364_f()).field_71075_bZ.field_75099_e) {
            return false;
        }
        if (this.hasImage()) {
            ItemStack image = this.removeImage();
            if (!this.field_70170_p.field_72995_K) {
                this.playRemoveSound();
                this.dropItem(image);
            }
            return true;
        }
        this.removeFrame(source.func_76346_g());
        return true;
    }

    public boolean isValid() {
        return !this.field_70170_p.func_184143_b(this.func_174813_aQ()) && this.field_70170_p.func_175647_a(EntityImage.class, this.func_174813_aQ().func_72314_b(this.getFacing().func_82601_c() == 0 ? -0.125 : 0.0, this.getFacing().func_96559_d() == 0 ? -0.125 : 0.0, this.getFacing().func_82599_e() == 0 ? -0.125 : 0.0), image -> image != this).isEmpty();
    }

    public void checkValid() {
        if (!this.isValid()) {
            this.removeFrame();
        }
    }

    public void onBroken(Entity entity) {
        if (!this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.dropItem(new ItemStack((Item)ModItems.IMAGE_FRAME));
        if (this.hasImage()) {
            this.dropItem(this.removeImage());
        }
    }

    public void resize(MessageResizeFrame.Direction direction, boolean larger) {
        int amount = larger ? 1 : -1;
        switch (direction) {
            case UP: {
                this.setHeight(this.getHeight() + amount);
                break;
            }
            case DOWN: {
                if (!this.setHeight(this.getHeight() + amount)) break;
                this.setImagePosition(this.func_180425_c().func_177967_a(EnumFacing.DOWN, amount));
                break;
            }
            case RIGHT: {
                this.setWidth(this.getWidth() + amount);
                break;
            }
            case LEFT: {
                if (!this.setWidth(this.getWidth() + amount)) break;
                this.setImagePosition(this.func_180425_c().func_177967_a(this.getResizeOffset(), amount));
            }
        }
    }

    private EnumFacing getResizeOffset() {
        switch (this.getFacing()) {
            default: {
                return EnumFacing.SOUTH;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.EAST;
            }
            case SOUTH: 
        }
        return EnumFacing.WEST;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.hasImage()) {
            return this.getItem().func_77946_l();
        }
        return new ItemStack((Item)ModItems.IMAGE_FRAME);
    }

    private void updateBoundingBox() {
        BlockPos pos = this.func_180425_c();
        EnumFacing facing = this.getFacing();
        int width = this.getWidth();
        int height = this.getHeight();
        if (facing.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = (float)facing.func_176736_b() * 90.0f;
        } else {
            this.field_70125_A = -90.0f * (float)facing.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.boundingBox = this.calculateBoundingBox(pos, facing, width, height);
    }

    private AxisAlignedBB calculateBoundingBox(BlockPos pos, EnumFacing facing, double width, double height) {
        switch (facing) {
            default: {
                return new AxisAlignedBB((double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 1.0 - 0.0625, (double)pos.func_177958_n() - width + 1.0, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + width, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + 0.0625);
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n() + 1.0 - 0.0625, (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + width);
            }
            case EAST: 
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + 1.0, (double)pos.func_177958_n() + 0.0625, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() - width + 1.0);
    }

    public BlockPos getCenterPosition() {
        Vec3d center = this.getCenter(this.func_174813_aQ());
        return new BlockPos(center.field_72450_a, center.field_72448_b, center.field_72449_c);
    }

    public Vec3d getCenter(AxisAlignedBB aabb) {
        return new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
    }

    @Nullable
    public EntityItem dropItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        BlockPos center = this.getCenterPosition();
        EntityItem entityitem = new EntityItem(this.field_70170_p, (double)center.func_177958_n() + 0.5, (double)center.func_177956_o() + 0.5, (double)center.func_177952_p() + 0.5, stack);
        entityitem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public void removeFrame(Entity source) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.onBroken(source);
            this.func_70106_y();
        }
    }

    public void removeFrame() {
        this.removeFrame(null);
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.boundingBox;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void playPlaceSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187694_dK, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void playAddSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void playRemoveSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public UUID getImageUUID() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(ID);
        if (uuid.isPresent()) {
            return (UUID)uuid.get();
        }
        return null;
    }

    public void setUUID(UUID uuid) {
        if (uuid == null) {
            this.field_70180_af.func_187227_b(ID, (Object)Optional.absent());
        } else {
            this.field_70180_af.func_187227_b(ID, (Object)Optional.of((Object)uuid));
        }
    }

    public int getWidth() {
        return (Integer)this.field_70180_af.func_187225_a(WIDTH);
    }

    public int getHeight() {
        return (Integer)this.field_70180_af.func_187225_a(HEIGHT);
    }

    public boolean setWidth(int width) {
        if (width <= 0) {
            width = 1;
        } else if (width > 12) {
            width = 12;
        }
        int oldWidth = this.getWidth();
        this.field_70180_af.func_187227_b(WIDTH, (Object)width);
        return oldWidth != width;
    }

    public boolean setHeight(int height) {
        if (height <= 0) {
            height = 1;
        } else if (height > 12) {
            height = 12;
        }
        int oldHeight = this.getHeight();
        this.field_70180_af.func_187227_b(HEIGHT, (Object)height);
        return oldHeight != height;
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEM, (Object)stack);
    }

    public void setImagePosition(BlockPos position) {
        this.func_70012_b((double)position.func_177958_n() + 0.5, position.func_177956_o(), (double)position.func_177952_p() + 0.5, this.field_70177_z, this.field_70125_A);
        this.updateBoundingBox();
    }

    public void setFacing(EnumFacing facing) {
        this.field_70180_af.func_187227_b(FACING, (Object)facing);
        this.updateBoundingBox();
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(FACING);
    }

    private boolean hasImage() {
        return !this.getItem().func_190926_b();
    }

    private ItemStack removeImage() {
        ItemStack item = this.getItem();
        this.setItem(ItemStack.field_190927_a);
        this.setUUID(null);
        return item;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.NORTH);
        this.field_70180_af.func_187214_a(WIDTH, (Object)1);
        this.field_70180_af.func_187214_a(HEIGHT, (Object)1);
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("id_most") && compound.func_74764_b("id_least")) {
            this.setUUID(new UUID(compound.func_74763_f("id_most"), compound.func_74763_f("id_least")));
        }
        this.setFacing(EnumFacing.func_82600_a((int)compound.func_74762_e("facing")));
        this.setWidth(compound.func_74762_e("width"));
        this.setHeight(compound.func_74762_e("height"));
        this.setItem(new ItemStack(compound.func_74775_l("item")));
        this.updateBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.getImageUUID() != null) {
            UUID uuid = this.getImageUUID();
            compound.func_74772_a("id_most", uuid.getMostSignificantBits());
            compound.func_74772_a("id_least", uuid.getLeastSignificantBits());
        }
        compound.func_74768_a("facing", this.getFacing().func_176745_a());
        compound.func_74768_a("width", this.getWidth());
        compound.func_74768_a("height", this.getHeight());
        compound.func_74782_a("item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
    }
}

