/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

public final class TextUtil {
    private static final String ROMAN_NUMBERS = "\u2182M\u2182\u2181M\u2181MCMDCDCXCLXLXIXVIVI";
    private static final String ROMAN_VALUES = "\u2710\u2328\u1388\u0fa0\u03e8\u0384\u01f4\u0190dZ2(\n\t\u0005\u0004\u0001";
    public static final int MAX_ROMAN_INTEGER = 39999;

    private TextUtil() {
    }

    public static int countNumLines(CharSequence str) {
        int n = str.length();
        int count = 0;
        if (n > 0) {
            ++count;
            for (int i = 0; i < n; ++i) {
                if (str.charAt(i) != '\n') continue;
                ++count;
            }
        }
        return count;
    }

    public static String stripNewLines(String str) {
        int idx = str.lastIndexOf(10);
        if (idx < 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        do {
            if (sb.charAt(idx) != '\n') continue;
            sb.deleteCharAt(idx);
        } while (--idx >= 0);
        return sb.toString();
    }

    public static String limitStringLength(String str, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static String notNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static int indexOf(CharSequence cs, char ch, int start) {
        return TextUtil.indexOf(cs, ch, start, cs.length());
    }

    public static int indexOf(CharSequence cs, char ch, int start, int end) {
        while (start < end) {
            if (cs.charAt(start) == ch) {
                return start;
            }
            ++start;
        }
        return end;
    }

    public static int indexOf(String str, char ch, int start) {
        int idx = str.indexOf(ch, start);
        if (idx < 0) {
            return str.length();
        }
        return idx;
    }

    public static int skipSpaces(CharSequence s, int start) {
        return TextUtil.skipSpaces(s, start, s.length());
    }

    public static int skipSpaces(CharSequence s, int start, int end) {
        while (start < end && Character.isWhitespace(s.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static String trim(CharSequence s, int start) {
        return TextUtil.trim(s, start, s.length());
    }

    public static String trim(CharSequence s, int start, int end) {
        start = TextUtil.skipSpaces(s, start, end);
        while (end > start && Character.isWhitespace(s.charAt(end - 1))) {
            --end;
        }
        if (s instanceof String) {
            return ((String)s).substring(start, end);
        }
        if (s instanceof StringBuilder) {
            return ((StringBuilder)s).substring(start, end);
        }
        return s.subSequence(start, end).toString();
    }

    public static String createString(char ch, int len) {
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static int[] parseIntArray(String str) throws NumberFormatException {
        int count = TextUtil.countElements(str);
        int[] result = new int[count];
        int pos = 0;
        for (int idx = 0; idx < count; ++idx) {
            int comma = TextUtil.indexOf(str, ',', pos);
            result[idx] = Integer.parseInt(str.substring(pos, comma));
            pos = comma + 1;
        }
        return result;
    }

    public static int countElements(String str) {
        int count = 0;
        int pos = 0;
        while (pos < str.length()) {
            ++count;
            pos = TextUtil.indexOf(str, ',', pos) + 1;
        }
        return count;
    }

    public static String toPrintableString(char ch) {
        if (Character.isISOControl(ch)) {
            return '\\' + Integer.toOctalString(ch);
        }
        return Character.toString(ch);
    }

    public static String toRomanNumberString(int value) throws IllegalArgumentException {
        if (value < 1 || value > 39999) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int idxValues = 0;
        int idxNumbers = 0;
        do {
            char romanValue = ROMAN_VALUES.charAt(idxValues);
            int romanNumberLen = (idxValues & 1) + 1;
            while (value >= romanValue) {
                sb.append(ROMAN_NUMBERS, idxNumbers, idxNumbers + romanNumberLen);
                value -= romanValue;
            }
            idxNumbers += romanNumberLen;
        } while (++idxValues < 17);
        return sb.toString();
    }

    public static String toCharListNumber(int value, String list) throws IllegalArgumentException {
        if (value < 1) {
            throw new IllegalArgumentException("value");
        }
        int pos = 16;
        char[] tmp = new char[pos];
        do {
            tmp[--pos] = list.charAt(--value % list.length());
        } while ((value /= list.length()) > 0);
        return new String(tmp, pos, tmp.length - pos);
    }
}

