/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.world;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.world.IWorldDataAdapter;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.ISaveHandler;

public enum WorldDataHandler {
    INSTANCE;

    private List<IWorldDataAdapter> dataAdapterList = new ArrayList<IWorldDataAdapter>();

    public void registerDataAdapter(IWorldDataAdapter dataAdapter) {
        this.dataAdapterList.add(dataAdapter);
    }

    public void loadWorldData(ISaveHandler saveHandler, World world) {
        if (world.field_73011_w.getDimension() == 0) {
            for (IWorldDataAdapter dataAdapter : this.dataAdapterList) {
                File dataFile = new File(this.getSaveFolder(saveHandler, world), dataAdapter.getID() + ".dat");
                if (!dataFile.exists()) continue;
                try {
                    FileInputStream inputStream = new FileInputStream(dataFile);
                    dataAdapter.loadNBTData(CompressedStreamTools.func_74796_a((InputStream)inputStream), world);
                    inputStream.close();
                }
                catch (IOException e) {
                    LLibrary.LOGGER.error("Failed to read file", (Throwable)e);
                }
            }
        }
    }

    public void saveWorldData(ISaveHandler saveHandler, World world) {
        if (world.field_73011_w.getDimension() == 0) {
            for (IWorldDataAdapter dataAdapter : this.dataAdapterList) {
                File dataFile = new File(this.getSaveFolder(saveHandler, world), dataAdapter.getID() + ".dat");
                if (dataFile.exists()) continue;
                try {
                    dataFile.createNewFile();
                }
                catch (IOException e) {
                    LLibrary.LOGGER.error("Failed to create file {}", (Object)dataFile.getName(), (Object)e);
                    continue;
                }
                NBTTagCompound compound = new NBTTagCompound();
                dataAdapter.saveNBTData(compound, world);
                try {
                    FileOutputStream outputStream = new FileOutputStream(dataFile);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)outputStream);
                    outputStream.close();
                }
                catch (IOException e) {
                    LLibrary.LOGGER.error("Failed to write file {}", (Object)dataFile.getName(), (Object)e);
                }
            }
        }
    }

    private File getSaveFolder(ISaveHandler saveHandler, World world) {
        IChunkLoader chunkLoader = saveHandler.func_75763_a(world.field_73011_w);
        File worldFolder = chunkLoader instanceof AnvilChunkLoader ? ((AnvilChunkLoader)chunkLoader).field_75825_d : saveHandler.func_75765_b();
        File saveFolder = new File(worldFolder, "llibrary");
        if (!saveFolder.exists()) {
            saveFolder.mkdirs();
        }
        return saveFolder;
    }
}

