/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VanillaButtonDescriptionHandler {
    private static Map<GuiButton, String> descriptions = new HashMap<GuiButton, String>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new VanillaButtonDescriptionHandler());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        descriptions.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post e) {
        for (Map.Entry<GuiButton, String> m : descriptions.entrySet()) {
            if (!m.getKey().func_146115_a()) continue;
            VanillaButtonDescriptionHandler.renderDescription(e.getMouseX(), e.getMouseY(), m.getValue());
            break;
        }
    }

    public static void setDescriptionFor(GuiButton w, String desc) {
        descriptions.put(w, desc);
    }

    private static void renderDescriptionBackground(int x, int y, int width, int height) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    private static void renderDescription(int mouseX, int mouseY, String desc) {
        if (desc != null) {
            String[] descArray;
            int width = 10;
            int height = 10;
            for (String s : descArray = StringUtils.splitLines((String)desc, (String)"%n%")) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_146294_l < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_146295_m < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((int)600);
            VanillaButtonDescriptionHandler.renderDescriptionBackground(mouseX, mouseY, width, height);
            GlStateManager.func_179147_l();
            int i2 = 5;
            for (String s : descArray) {
                Minecraft.func_71410_x().field_71462_r.func_73731_b(Minecraft.func_71410_x().field_71466_p, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost();
            GlStateManager.func_179084_k();
        }
    }
}

