/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.buttonactions;

import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionRegistry;
import de.keksuccino.fancymenu.menu.fancy.helper.DynamicValueTextfield;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.LayoutButton;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.buttonactions.LegacyButtonActions;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public class ButtonActionScreen
extends ScrollableScreen {
    protected static final Color ENTRY_BACK_1 = new Color(0, 0, 0, 50);
    protected static final Color ENTRY_BACK_2 = new Color(0, 0, 0, 90);
    public LayoutButton parentButton;
    protected List<ButtonAction> buttonActions = new ArrayList<ButtonAction>();
    protected int entryBackTick = 0;
    protected AdvancedButton doneButton;
    protected DynamicValueTextfield valueTextField;

    public ButtonActionScreen(GuiScreen parent, LayoutButton parentButton) {
        super(parent, Locals.localize((String)"fancymenu.helper.ui.button_action.set", (String[])new String[0]));
        this.parentButton = parentButton;
        this.doneButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, press -> {
            this.onDone();
            this.closeScreen();
        });
        this.doneButton.ignoreLeftMouseDownClickBlock = true;
        UIBase.colorizeButton(this.doneButton);
        this.valueTextField = new DynamicValueTextfield(Minecraft.func_71410_x().field_71466_p, 0, 0, 150, 20, true, null);
        this.valueTextField.func_146205_d(true);
        this.valueTextField.func_146195_b(false);
        this.valueTextField.func_146203_f(1000);
        if (this.parentButton.actionContent != null) {
            this.valueTextField.func_146180_a(this.parentButton.actionContent);
        }
        LegacyButtonActions.getLegacyActions(this).forEach(action -> this.addButtonAction((ButtonAction)((Object)action)));
        for (ButtonActionContainer c : ButtonActionRegistry.getActions()) {
            this.addButtonAction(new ButtonAction(this, c.getAction(), c.getActionDescription(), c.hasValue(), c.getValueDescription(), c.getValueExample(), null));
        }
        ButtonAction selectedAction = null;
        if (this.parentButton.actionType != null) {
            selectedAction = this.getButtonActionByName(this.parentButton.actionType);
        }
        if (selectedAction == null) {
            selectedAction = this.buttonActions.get(0);
        }
        this.setButtonActionSelected(selectedAction, true);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.scrollArea.height = this.field_146295_m - 165;
    }

    @Override
    public boolean isOverlayButtonHovered() {
        return this.doneButton.func_146115_a();
    }

    protected void addButtonAction(ButtonAction action) {
        this.buttonActions.add(action);
        if (this.entryBackTick == 0) {
            this.scrollArea.addEntry((ScrollAreaEntry)new ButtonActionScrollEntry(this.scrollArea, action, ENTRY_BACK_1));
            this.entryBackTick = 1;
        } else {
            this.scrollArea.addEntry((ScrollAreaEntry)new ButtonActionScrollEntry(this.scrollArea, action, ENTRY_BACK_2));
            this.entryBackTick = 0;
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.SeparatorEntry(this.scrollArea, 1, new Color(255, 255, 255, 100)));
    }

    protected void setButtonActionSelected(ButtonAction action, boolean selected) {
        action.selected = selected;
        this.buttonActions.forEach(ba -> {
            if (ba != action) {
                ba.selected = false;
            }
        });
    }

    @Nullable
    protected ButtonAction getSelectedButtonAction() {
        for (ButtonAction a : this.buttonActions) {
            if (!a.selected) continue;
            return a;
        }
        return null;
    }

    @Nullable
    protected ButtonAction getButtonActionByName(String name) {
        for (ButtonAction a : this.buttonActions) {
            if (!a.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    protected void onDone() {
        ButtonAction selected = this.getSelectedButtonAction();
        if (selected == null) {
            selected = this.buttonActions.get(0);
        }
        String value = null;
        if (selected.hasValue) {
            value = this.valueTextField.func_146179_b();
        }
        if (!this.parentButton.actionType.equals(selected.name) || !this.parentButton.actionContent.equals(value)) {
            this.parentButton.handler.history.saveSnapshot(this.parentButton.handler.history.createSnapshot());
        }
        this.parentButton.actionType = selected.name;
        this.parentButton.actionContent = value;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int footerHeight;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ButtonAction selected = this.getSelectedButtonAction();
        if (selected == null) {
            selected = this.buttonActions.get(0);
        }
        int xCenter = this.field_146294_l / 2;
        ButtonActionScreen.func_73734_a((int)0, (int)(this.field_146295_m - 115), (int)this.field_146294_l, (int)this.field_146295_m, (int)HEADER_FOOTER_COLOR.getRGB());
        this.doneButton.field_146128_h = xCenter - this.doneButton.field_146120_f / 2;
        this.doneButton.field_146129_i = this.field_146295_m - 35;
        this.doneButton.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        if (selected.hasValue) {
            this.func_73732_a(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.custombutton.config.actionvalue", (String[])new String[]{selected.valueDesc}), xCenter, this.field_146295_m - 100, -1);
            this.valueTextField.field_146209_f = xCenter - this.valueTextField.func_146200_o() / 2;
            this.valueTextField.field_146210_g = this.field_146295_m - 85;
            this.valueTextField.func_146184_c(selected.hasValue);
            this.valueTextField.func_146194_f();
            this.func_73732_a(Minecraft.func_71410_x().field_71466_p, Locals.localize((String)"helper.creator.custombutton.config.actionvalue.example", (String[])new String[]{selected.valueExample}), xCenter, this.field_146295_m - 60, -1);
        }
        if (mouseY < this.field_146295_m - (footerHeight = 115)) {
            for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
                String desc;
                if (!(e instanceof ButtonActionScrollEntry) || !e.isHovered() || (desc = ((ButtonActionScrollEntry)e).action.desc) == null) continue;
                ButtonActionScreen.renderDescription(Arrays.asList(StringUtils.splitLines((String)desc, (String)"%n%")), mouseX, mouseY);
            }
        }
    }

    public static class ButtonAction
    extends Gui {
        protected ButtonActionScreen parent;
        protected String name;
        protected String desc;
        protected String valueDesc;
        protected String valueExample;
        protected CharacterFilter valueFilter = null;
        protected boolean hasValue;
        protected boolean selected = false;

        public ButtonAction(ButtonActionScreen parent, String name, String desc, boolean hasValue, @Nullable String valueDesc, @Nullable String valueExample, @Nullable CharacterFilter valueFilter) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueDesc = valueDesc;
            this.valueFilter = valueFilter;
            this.hasValue = hasValue;
            this.valueExample = valueExample;
        }

        public void render(int mouseX, int mouseY, ButtonActionScrollEntry entry) {
            int centerX = entry.x + entry.getWidth() / 2;
            int centerY = entry.y + entry.getHeight() / 2;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            Color nameBackColor = new Color(255, 255, 255, 30);
            String renderName = "\u00a7l" + this.name;
            if (this.selected) {
                renderName = "\u00a7a\u00a7l" + this.name;
            }
            int nameWidth = font.func_78256_a(renderName);
            int nameX = centerX - nameWidth / 2;
            int nameY = centerY - 5;
            ButtonAction.func_73734_a((int)(nameX - 5), (int)(nameY - 5), (int)(nameX + nameWidth + 5), (int)(nameY + font.field_78288_b + 5), (int)nameBackColor.getRGB());
            this.func_73732_a(font, renderName, centerX, nameY, -1);
        }

        protected void setSelected(boolean selected) {
            this.parent.setButtonActionSelected(this, selected);
        }
    }

    public static class ButtonActionScrollEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public ButtonAction action;
        public Color backgroundColor;
        protected boolean leftMouseDown = false;

        public ButtonActionScrollEntry(ScrollArea parent, ButtonAction action, Color backgroundColor) {
            super(parent, call -> {});
            this.action = action;
            this.backgroundColor = backgroundColor;
            this.setHeight(30);
        }

        @Override
        public void renderEntry() {
            super.renderEntry();
            int footerHeight = 115;
            if (!this.leftMouseDown && MouseInput.getMouseY() < this.action.parent.field_146295_m - footerHeight && this.isHovered() && MouseInput.isLeftMouseDown()) {
                this.action.setSelected(true);
            }
            this.leftMouseDown = MouseInput.isLeftMouseDown();
            ButtonActionScrollEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)this.backgroundColor.getRGB());
            this.action.render(MouseInput.getMouseX(), MouseInput.getMouseY(), this);
        }
    }
}

