/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.tileentity.TileEntityBoost;
import com.mrcrayfish.vehicle.util.StateHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBoostPad
extends BlockRotatedObject {
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    protected static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockBoostPad() {
        super(Material.field_151576_e, "vehicle:boost_pad");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.6f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)(this.func_149739_a() + ".info"), (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EnumFacing facing;
        if (entityIn instanceof EntityPoweredVehicle && entityIn.func_184179_bs() != null && (facing = (EnumFacing)state.func_177229_b((IProperty)FACING)) == entityIn.func_174811_aO()) {
            EntityPoweredVehicle poweredVehicle;
            float speedMultiplier = 0.0f;
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityBoost) {
                speedMultiplier = ((TileEntityBoost)tileEntity).getSpeedMultiplier();
            }
            if (!(poweredVehicle = (EntityPoweredVehicle)entityIn).isBoosting()) {
                worldIn.func_184133_a(null, pos, ModSounds.BOOST_PAD, SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            poweredVehicle.setBoosting(true);
            poweredVehicle.currentSpeed = poweredVehicle.getActualMaxSpeed();
            poweredVehicle.speedMultiplier = speedMultiplier;
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (StateHelper.getBlock(worldIn, pos, facing, StateHelper.Direction.LEFT) == this && StateHelper.getRotation(worldIn, pos, facing, StateHelper.Direction.LEFT) == StateHelper.Direction.DOWN) {
            state = state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        if (StateHelper.getBlock(worldIn, pos, facing, StateHelper.Direction.RIGHT) == this && StateHelper.getRotation(worldIn, pos, facing, StateHelper.Direction.RIGHT) == StateHelper.Direction.DOWN) {
            state = state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LEFT, RIGHT});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBoost(0.5f);
    }
}

