/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.vehicle.crafting.FluidExtract;
import com.mrcrayfish.vehicle.init.ModFluids;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class FluidExtractorRecipes {
    private static final FluidExtractorRecipes INSTANCE = new FluidExtractorRecipes();
    private final ImmutableMap<ItemStack, FluidExtract> extractingMap;

    public static FluidExtractorRecipes getInstance() {
        return INSTANCE;
    }

    private FluidExtractorRecipes() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)new ItemStack(Items.field_151079_bi), (Object)new FluidExtract(ModFluids.ENDER_SAP, 600));
        builder.put((Object)new ItemStack(Items.field_151072_bj), (Object)new FluidExtract(ModFluids.BLAZE_JUICE, 450));
        this.extractingMap = builder.build();
    }

    public ImmutableMap<ItemStack, FluidExtract> getExtractingMap() {
        return this.extractingMap;
    }

    @Nullable
    public FluidExtract getRecipeResult(ItemStack stack) {
        for (Map.Entry entry : this.extractingMap.entrySet()) {
            if (!FluidExtractorRecipes.areItemStacksEqual(stack, (ItemStack)entry.getKey())) continue;
            return (FluidExtract)entry.getValue();
        }
        return null;
    }

    private static boolean areItemStacksEqual(ItemStack stack, ItemStack other) {
        if (stack.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (stack.func_77952_i() != other.func_77952_i()) {
            return false;
        }
        if (stack.func_77978_p() == null && other.func_77978_p() != null) {
            return false;
        }
        return stack.func_77978_p() == null || stack.func_77978_p().equals((Object)other.func_77978_p());
    }
}

