/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.block.BlockFluidPump;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidPipe;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPump
extends TileEntityFluidPipe {
    private PowerMode powerMode;

    public TileEntityFluidPump() {
        this.transferAmount = VehicleConfig.SERVER.pumpTransferAmount;
        this.powerMode = PowerMode.RQUIRES_SIGNAL_ON;
    }

    public void cyclePowerMode(EntityPlayer player) {
        this.powerMode = PowerMode.values()[(this.powerMode.ordinal() + 1) % PowerMode.values().length];
        this.powerMode.notifyPlayerOfChange(player);
        this.syncToClient();
    }

    @Override
    public void func_73660_a() {
        if (this.powerMode != PowerMode.ALWAYS_ACTIVE && this.field_145850_b.func_175640_z(this.field_174879_c) != (this.powerMode == PowerMode.RQUIRES_SIGNAL_ON)) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFluidPump.FACING);
        state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        ArrayList<IFluidHandler> fluidHandlers = new ArrayList<IFluidHandler>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IFluidHandler handler;
            if (this.disabledConnections[face.func_176745_a()] || !((Boolean)state.func_177229_b((IProperty)BlockFluidPump.CONNECTED_PIPES[face.func_176745_a()])).booleanValue() || (handler = this.getConnectedFluidHandler(face)) == null) continue;
            fluidHandlers.add(handler);
        }
        int outputCount = fluidHandlers.size();
        if (outputCount == 0) {
            return;
        }
        IFluidHandler handler = this.getConnectedFluidHandler(facing.func_176734_d());
        if (handler != null) {
            FluidUtils.transferFluid(handler, (IFluidHandler)this.tank, this.transferAmount);
        }
        if (outputCount == 1) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(0), this.transferAmount);
            return;
        }
        int remainder = Math.min(this.tank.getFluidAmount(), this.transferAmount * outputCount);
        int amount = remainder / outputCount;
        if (amount > 0) {
            fluidHandlers.removeIf(iFluidHandler -> FluidUtils.transferFluid((IFluidHandler)this.tank, iFluidHandler, amount) < amount);
        }
        remainder %= outputCount;
        if (fluidHandlers.size() == 1) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(0), remainder);
        }
        for (int i = 0; i < remainder && !fluidHandlers.isEmpty(); ++i) {
            int index = this.field_145850_b.field_73012_v.nextInt(fluidHandlers.size());
            int filled = FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(index), 1);
            remainder -= filled;
            if (filled != 0) continue;
            fluidHandlers.remove(index);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        FluidUtils.fixEmptyTag(tag);
        super.func_145839_a(tag);
        this.powerMode = PowerMode.values()[tag.func_74762_e("power_mode")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("power_mode", this.powerMode.ordinal());
        return tag;
    }

    public static enum PowerMode {
        ALWAYS_ACTIVE("always"),
        RQUIRES_SIGNAL_ON("on"),
        REQUIRES_SIGNAL_OFF("off");

        private static final String LANG_KEY_CHAT_PREFIX = "vehicle.chat.pump.power";
        private String langKeyChat;

        private PowerMode(String langKeyChat) {
            this.langKeyChat = langKeyChat;
        }

        public void notifyPlayerOfChange(EntityPlayer player) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(LANG_KEY_CHAT_PREFIX, new Object[]{new TextComponentTranslation("vehicle.chat.pump.power." + this.langKeyChat, new Object[0])}));
        }
    }
}

