/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.theme.ParameterMapImpl;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twl.utils.XMLParser;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.xmlpull.v1.XmlPullParserException;

final class ParserUtil {
    private ParserUtil() {
    }

    static void checkNameNotEmpty(String name, XMLParser xmlp) throws XmlPullParserException {
        if (name == null) {
            throw xmlp.error("missing 'name' on '" + xmlp.getName() + "'");
        }
        if (name.length() == 0) {
            throw xmlp.error("empty name not allowed");
        }
        if ("none".equals(name)) {
            throw xmlp.error("can't use reserved name \"none\"");
        }
        if (name.indexOf(42) >= 0) {
            throw xmlp.error("'*' is not allowed in names");
        }
        if (name.indexOf(47) >= 0) {
            throw xmlp.error("'/' is not allowed in names");
        }
    }

    static Border parseBorderFromAttribute(XMLParser xmlp, String attribute) throws XmlPullParserException {
        String value = xmlp.getAttributeValue(null, attribute);
        if (value == null) {
            return null;
        }
        return ParserUtil.parseBorder(xmlp, value);
    }

    static Border parseBorder(XMLParser xmlp, String value) throws XmlPullParserException {
        try {
            int[] values = TextUtil.parseIntArray(value);
            switch (values.length) {
                case 1: {
                    return new Border(values[0]);
                }
                case 2: {
                    return new Border(values[0], values[1]);
                }
                case 4: {
                    return new Border(values[0], values[1], values[2], values[3]);
                }
            }
            throw xmlp.error("Unsupported border format");
        }
        catch (NumberFormatException ex) {
            throw xmlp.error("Unable to parse border size", ex);
        }
    }

    static Color parseColorFromAttribute(XMLParser xmlp, String attribute, ParameterMapImpl constants, Color defaultColor) throws XmlPullParserException {
        String value = xmlp.getAttributeValue(null, attribute);
        if (value == null) {
            return defaultColor;
        }
        return ParserUtil.parseColor(xmlp, value, constants);
    }

    static Color parseColor(XMLParser xmlp, String value, ParameterMapImpl constants) throws XmlPullParserException {
        try {
            Color color = Color.parserColor(value);
            if (color == null && constants != null) {
                color = constants.getParameterValue(value, false, Color.class);
            }
            if (color == null) {
                throw xmlp.error("Unknown color name: " + value);
            }
            return color;
        }
        catch (NumberFormatException ex) {
            throw xmlp.error("unable to parse color code", ex);
        }
    }

    static String appendDot(String name) {
        int len = name.length();
        if (len > 0 && name.charAt(len - 1) != '.') {
            name = name.concat(".");
        }
        return name;
    }

    static int[] parseIntArrayFromAttribute(XMLParser xmlp, String attribute) throws XmlPullParserException {
        try {
            String value = xmlp.getAttributeNotNull(attribute);
            return TextUtil.parseIntArray(value);
        }
        catch (NumberFormatException ex) {
            throw xmlp.error("Unable to parse", ex);
        }
    }

    static <V> SortedMap<String, V> find(SortedMap<String, V> map, String baseName) {
        return map.subMap(baseName, baseName.concat("\uffff"));
    }

    static <V> Map<String, V> resolve(SortedMap<String, V> map, String ref, String name, V mapToNull) {
        name = ParserUtil.appendDot(name);
        int refLen = ref.length() - 1;
        SortedMap<String, V> matched = ParserUtil.find(map, ref = ref.substring(0, refLen));
        if (matched.isEmpty()) {
            return matched;
        }
        HashMap<String, V> result = new HashMap<String, V>();
        for (Map.Entry<String, V> texEntry : matched.entrySet()) {
            String entryName = texEntry.getKey();
            assert (entryName.startsWith(ref));
            V value = texEntry.getValue();
            if (value == mapToNull) {
                value = null;
            }
            result.put(name.concat(entryName.substring(refLen)), value);
        }
        return result;
    }

    static StateExpression parseCondition(XMLParser xmlp) throws XmlPullParserException {
        boolean negate;
        String expression = xmlp.getAttributeValue(null, "if");
        boolean bl = negate = expression == null;
        if (expression == null) {
            expression = xmlp.getAttributeValue(null, "unless");
        }
        if (expression != null) {
            try {
                return StateExpression.parse(expression, negate);
            }
            catch (ParseException ex) {
                throw xmlp.error("Unable to parse condition", ex);
            }
        }
        return null;
    }
}

