/*
 * Decompiled with CFR 0.152.
 */
package drzhark.guiapi.widget;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import drzhark.guiapi.GuiWidgetScreen;
import drzhark.guiapi.ModSettings;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class WidgetItem2DRender
extends Widget {
    private static Field isDrawingField;
    private static RenderItem itemRenderer;
    private ItemStack renderStack;
    private int scaleType = 0;

    public WidgetItem2DRender() {
        this(0);
    }

    public WidgetItem2DRender(int renderID) {
        this(new ItemStack(Item.func_150899_d((int)renderID), 0, 0));
    }

    public WidgetItem2DRender(ItemStack renderStack) {
        this.setMinSize(16, 16);
        this.setTheme("/progressbar");
    }

    public int getRenderID() {
        return this.renderStack == null ? 0 : Item.func_150891_b((Item)this.renderStack.func_77973_b());
    }

    public ItemStack getRenderStack() {
        return this.renderStack;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    private boolean isDrawing(Tessellator tesselator) {
        if (isDrawingField == null) {
            return false;
        }
        try {
            isDrawingField.getBoolean(tesselator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void paintWidget(GUI gui) {
        int stackBeforeDraw;
        GuiWidgetScreen screen;
        block14: {
            Minecraft minecraft = ModSettings.getMcinst();
            int x = this.getX();
            int y = this.getY();
            float scalex = 1.0f;
            float scaley = 1.0f;
            int maxWidth = this.getInnerWidth() - 4;
            int maxHeight = this.getInnerHeight() - 4;
            int scale = this.getScaleType();
            if (scale == -1 && (maxWidth < 16 || maxHeight < 16)) {
                scale = 0;
            }
            switch (scale) {
                case 0: {
                    int size = 0;
                    size = maxWidth > maxHeight ? maxHeight : maxWidth;
                    x += (maxWidth - size) / 2;
                    y += (maxHeight - size) / 2;
                    scaley = scalex = (float)size / 16.0f;
                    x = (int)((float)x / scalex);
                    y = (int)((float)y / scaley);
                    break;
                }
                case -1: {
                    int size = maxWidth - 16;
                    x += size / 2;
                    size = maxHeight - 16;
                    y += size / 2;
                    break;
                }
                case 1: {
                    scalex = (float)maxWidth / 16.0f;
                    scaley = (float)maxHeight / 16.0f;
                    x = (int)((float)x / scalex);
                    y = (int)((float)y / scaley);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Scale Type is out of bounds! This should never happen!");
                }
            }
            x += 2;
            ++y;
            if (minecraft == null || this.getRenderStack() == null || this.getRenderStack().func_77973_b() == null) {
                return;
            }
            screen = GuiWidgetScreen.getInstance();
            screen.renderer.pauseRendering();
            screen.renderer.setClipRect();
            GL11.glEnable((int)3089);
            GL11.glPushMatrix();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            GL11.glScalef((float)scalex, (float)scaley, (float)1.0f);
            ItemStack stack = this.getRenderStack();
            if (this.isDrawing(Tessellator.func_178181_a())) {
                this.setDrawing(Tessellator.func_178181_a(), false);
            }
            stackBeforeDraw = GL11.glGetInteger((int)2979);
            try {
                itemRenderer.func_175042_a(stack, x, y);
                if (this.isDrawing(Tessellator.func_178181_a())) {
                    this.setDrawing(Tessellator.func_178181_a(), false);
                }
                itemRenderer.func_180453_a(minecraft.field_71466_p, stack, x, y, null);
                if (this.isDrawing(Tessellator.func_178181_a())) {
                    this.setDrawing(Tessellator.func_178181_a(), false);
                }
            }
            catch (Throwable e) {
                if (!this.isDrawing(Tessellator.func_178181_a())) break block14;
                this.setDrawing(Tessellator.func_178181_a(), false);
            }
        }
        int stackAfterDraw = GL11.glGetInteger((int)2979);
        if (stackBeforeDraw != stackAfterDraw) {
            for (int i = 0; i < stackAfterDraw - stackBeforeDraw; ++i) {
                GL11.glPopMatrix();
            }
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
        screen.renderer.resumeRendering();
    }

    private void setDrawing(Tessellator tesselator, boolean state) {
        if (isDrawingField == null) {
            return;
        }
        try {
            isDrawingField.setBoolean(tesselator, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setScaleType(int scaleType) {
        if (scaleType > 1) {
            scaleType = 1;
        }
        if (scaleType < -1) {
            scaleType = -1;
        }
        this.scaleType = scaleType;
    }

    static {
        itemRenderer = Minecraft.func_71410_x().func_175599_af();
        try {
            isDrawingField = Tessellator.class.getDeclaredField("z");
            isDrawingField.setAccessible(true);
        }
        catch (Throwable e) {
            try {
                isDrawingField = Tessellator.class.getDeclaredField("isDrawing");
                isDrawingField.setAccessible(true);
            }
            catch (Throwable e2) {
                System.out.println("GuiAPI Warning: Unable to get Tessellator.isDrawing field! There will be a chance of crashes if you attempt to render a mod item!");
            }
        }
    }
}

