/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import de.keksuccino.fancymenu.menu.fancy.helper.SetupSharingEngine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.MenuBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class ChooseSavedSetupPopup
extends FMPopup {
    public Color overlayColor = new Color(26, 26, 26);
    protected ScrollArea scroll;
    protected Consumer<File> callback;
    protected AdvancedButton chooseButton;
    protected AdvancedButton closeButton;
    protected SetupEntry focused;
    protected int lastWidth = 0;
    protected int lastHeight = 0;

    public ChooseSavedSetupPopup(Consumer<File> callback) {
        super(240);
        this.callback = callback;
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
        this.updateScrollList();
        this.chooseButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.choosefile.choose", (String[])new String[0]), true, press -> {
            if (this.focused != null) {
                this.close();
            }
        });
        this.addButton(this.chooseButton);
        this.colorizePopupButton(this.chooseButton);
        this.closeButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
        });
        this.addButton(this.closeButton);
        this.colorizePopupButton(this.closeButton);
    }

    public void render(int mouseX, int mouseY, GuiScreen renderIn) {
        SetupSharingEngine.SetupProperties sp;
        File props;
        SetupEntry hoveredEntry;
        super.render(mouseX, mouseY, renderIn);
        if (this.lastWidth != renderIn.field_146294_l || this.lastHeight != renderIn.field_146295_m) {
            this.updateScrollList();
            this.focused = null;
        }
        this.lastWidth = renderIn.field_146294_l;
        this.lastHeight = renderIn.field_146295_m;
        this.scroll.height = renderIn.field_146295_m - 100;
        this.scroll.y = 40;
        this.scroll.x = renderIn.field_146294_l / 2 - this.scroll.width / 2;
        this.scroll.render();
        ChooseSavedSetupPopup.func_73734_a((int)0, (int)0, (int)renderIn.field_146294_l, (int)40, (int)this.overlayColor.getRGB());
        ChooseSavedSetupPopup.func_73734_a((int)0, (int)(renderIn.field_146295_m - 60), (int)renderIn.field_146294_l, (int)renderIn.field_146295_m, (int)this.overlayColor.getRGB());
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "\u00a7l" + Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved", (String[])new String[0]), renderIn.field_146294_l / 2, 17, Color.WHITE.getRGB());
        this.chooseButton.field_146128_h = renderIn.field_146294_l / 2 - this.chooseButton.field_146120_f - 5;
        this.chooseButton.field_146129_i = renderIn.field_146295_m - 40;
        this.closeButton.field_146128_h = renderIn.field_146294_l / 2 + 5;
        this.closeButton.field_146129_i = renderIn.field_146295_m - 40;
        this.renderButtons(mouseX, mouseY);
        if (this.focused != null && !this.focused.focused) {
            this.focused = null;
        }
        if ((hoveredEntry = this.getHoveredEntry()) != null && (props = new File(hoveredEntry.setupFolder.getPath() + "/setup.properties")).isFile() && (sp = SetupSharingEngine.deserializePropertiesFile(props.getPath())) != null) {
            String modified = "???";
            try {
                LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochMilli(hoveredEntry.setupFolder.lastModified()), ZoneId.systemDefault());
                DateTimeFormatter dtf = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
                dtf.withZone(ZoneId.systemDefault());
                dtf.withLocale(Locale.getDefault());
                modified = dt.format(dtf);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            String[] desc = new String[]{Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip", (String[])new String[0]), " ", Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.datemodified", (String[])new String[]{modified}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.mcversion", (String[])new String[]{sp.mcVersion}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.fmversion", (String[])new String[]{sp.fmVersion}), Locals.localize((String)"fancymenu.helper.setupsharing.import.choosefromsaved.tooltip.modloader", (String[])new String[]{sp.modLoader})};
            ChooseSavedSetupPopup.renderDescription(MouseInput.getMouseX(), MouseInput.getMouseY(), desc);
        }
    }

    protected SetupEntry getHoveredEntry() {
        for (ScrollAreaEntry e : this.scroll.getEntries()) {
            if (!e.isHovered()) continue;
            return (SetupEntry)e;
        }
        return null;
    }

    public void updateScrollList() {
        this.scroll = new ScrollArea(0, 0, 200, 0);
        this.scroll.backgroundColor = new Color(255, 255, 255, 20);
        File f = SetupSharingEngine.FM_SETUPS_DIR;
        if (f.isDirectory()) {
            for (File setupDir : f.listFiles()) {
                if (!SetupSharingEngine.isValidSetup(setupDir.getPath())) continue;
                this.scroll.addEntry((ScrollAreaEntry)new SetupEntry(this, setupDir));
            }
        }
    }

    public void close() {
        this.setDisplayed(false);
        if (this.callback != null) {
            if (this.focused != null) {
                this.callback.accept(this.focused.setupFolder);
            } else {
                this.callback.accept(null);
            }
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            if (this.callback != null) {
                this.callback.accept(null);
            }
            this.setDisplayed(false);
        }
    }

    private static void renderDescription(int mouseX, int mouseY, String ... desc) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_146294_l < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_146295_m < mouseY + height) {
                mouseY -= height + 10;
            }
            GlStateManager.func_179147_l();
            ChooseSavedSetupPopup.renderDescriptionBackground(mouseX, mouseY, width, height);
            int i2 = 5;
            for (String s : desc) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(s, mouseX + 5, mouseY + i2, -1);
                i2 += 10;
            }
        }
    }

    private static void renderDescriptionBackground(int x, int y, int width, int height) {
        Color borderColor = Color.WHITE;
        Color backColor = new Color(26, 26, 26, 250);
        ChooseSavedSetupPopup.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)backColor.getRGB());
        ChooseSavedSetupPopup.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + height), (int)borderColor.getRGB());
        ChooseSavedSetupPopup.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 1), (int)borderColor.getRGB());
        ChooseSavedSetupPopup.func_73734_a((int)(x + width - 1), (int)y, (int)(x + width), (int)(y + height), (int)borderColor.getRGB());
        ChooseSavedSetupPopup.func_73734_a((int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)borderColor.getRGB());
    }

    public static class SetupEntry
    extends ScrollAreaEntry {
        public ChooseSavedSetupPopup chooser;
        protected File setupFolder;
        protected int clickTick = 0;
        protected boolean clickPre = false;
        protected boolean click = false;
        protected boolean focused = false;

        public SetupEntry(ChooseSavedSetupPopup chooser, File setupFolder) {
            super(chooser.scroll);
            this.chooser = chooser;
            this.setupFolder = setupFolder;
        }

        public void render() {
            if (this.isHovered() && this.isVisible() && MouseInput.isLeftMouseDown()) {
                this.focused = true;
                this.chooser.focused = this;
                if (!this.click) {
                    this.clickPre = true;
                    this.clickTick = 0;
                }
            }
            if (!this.isHovered() && MouseInput.isLeftMouseDown()) {
                this.focused = false;
            }
            super.render();
        }

        public void renderEntry() {
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MenuBar.FM_LOGO_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SetupEntry.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)20, (int)20, (float)20.0f, (float)20.0f);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            String name = this.setupFolder.getName();
            int maxNameWidth = this.getWidth() - 30 - 8;
            if (font.func_78256_a(name) > maxNameWidth) {
                name = font.func_78269_a(name, maxNameWidth) + "..";
            }
            font.func_175063_a(name, (float)(this.x + 30), (float)(this.y + 7), -1);
            if (!MouseInput.isLeftMouseDown() && this.clickPre) {
                this.click = true;
                this.clickPre = false;
                this.clickTick = 0;
            }
            if (this.click) {
                if (this.clickTick < 15) {
                    ++this.clickTick;
                } else {
                    this.click = false;
                    this.clickTick = 0;
                }
                if (MouseInput.isLeftMouseDown() && this.isHovered()) {
                    this.onClick();
                    this.click = false;
                    this.clickTick = 0;
                }
            }
            if (this.focused) {
                this.renderBorder();
            }
        }

        private void renderBorder() {
            SetupEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + 1), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
            SetupEntry.func_73734_a((int)(this.x + this.getWidth() - 1), (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
            SetupEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + 1), (int)Color.WHITE.getRGB());
            SetupEntry.func_73734_a((int)this.x, (int)(this.y + this.getHeight() - 1), (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)Color.WHITE.getRGB());
        }

        public void onClick() {
            this.chooser.close();
        }

        public int getHeight() {
            return 20;
        }
    }
}

