/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements;

import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirement;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements.LegacyVisibilityRequirements;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public class VisibilityRequirementsScreen
extends ScrollableScreen {
    protected static final Color ENTRY_BACK_1 = new Color(0, 0, 0, 50);
    protected static final Color ENTRY_BACK_2 = new Color(0, 0, 0, 90);
    public CustomizationItemBase parentItem;
    protected int entryBackTick = 0;
    protected AdvancedButton doneButton;

    public VisibilityRequirementsScreen(GuiScreen parent, CustomizationItemBase parentItem) {
        super(parent, Locals.localize((String)"fancymenu.helper.ui.visibility_requirements.manage", (String[])new String[0]));
        this.parentItem = parentItem;
        this.doneButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, press -> Minecraft.func_71410_x().func_147108_a(this.parent));
        this.doneButton.ignoreLeftMouseDownClickBlock = true;
        UIBase.colorizeButton(this.doneButton);
        VisibilityRequirementContainer c = this.parentItem.visibilityRequirementContainer;
        LegacyVisibilityRequirements.getLegacyRequirements(this, c).forEach(req -> this.addRequirement((Requirement)((Object)req)));
        for (VisibilityRequirementContainer.RequirementPackage p : c.customRequirements.values()) {
            VisibilityRequirement v = p.requirement;
            String valuePreset = null;
            if (v.hasValue()) {
                valuePreset = v.getValuePreset();
                if (valuePreset == null) {
                    valuePreset = "";
                }
                if (p.value != null) {
                    valuePreset = p.value;
                }
            }
            Consumer<String> valueCallback = null;
            if (v.hasValue()) {
                valueCallback = call -> {
                    p.value = call;
                };
            }
            CharacterFilter charFilter = v.getValueInputFieldFilter();
            String desc = "";
            for (String s : v.getDescription()) {
                if (s.equalsIgnoreCase("")) {
                    s = " ";
                }
                if (desc.equalsIgnoreCase("")) {
                    desc = desc + s;
                    continue;
                }
                desc = desc + "%n%" + s;
            }
            Requirement req2 = new Requirement(this, v.getDisplayName(), desc, v.getValueDisplayName(), p.checkFor, p.showIf, enabledCallback -> {
                p.checkFor = enabledCallback;
            }, showIfCallback -> {
                p.showIf = showIfCallback;
            }, valueCallback, charFilter, valuePreset);
            this.addRequirement(req2);
        }
    }

    @Override
    public boolean isOverlayButtonHovered() {
        return this.doneButton.func_146115_a();
    }

    protected void addRequirement(Requirement requirement) {
        if (this.entryBackTick == 0) {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_1));
            this.entryBackTick = 1;
        } else {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_2));
            this.entryBackTick = 0;
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.SeparatorEntry(this.scrollArea, 1, new Color(255, 255, 255, 100)));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int xCenter = this.field_146294_l / 2;
        this.doneButton.field_146128_h = xCenter - this.doneButton.field_146120_f / 2;
        this.doneButton.field_146129_i = this.field_146295_m - 35;
        this.doneButton.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
    }

    public static class Requirement
    extends Gui {
        protected VisibilityRequirementsScreen parent;
        protected String name;
        protected String desc;
        protected String valueName;
        protected Consumer<Boolean> enabledCallback;
        protected Consumer<Boolean> showIfCallback;
        protected Consumer<String> valueCallback;
        protected CharacterFilter valueFilter;
        protected boolean enabled;
        protected boolean showIf;
        protected String valueString;
        protected boolean hasValue = false;
        protected List<Runnable> preRenderTasks = new ArrayList<Runnable>();
        protected List<AdvancedButton> buttonList = new ArrayList<AdvancedButton>();
        protected AdvancedButton enableRequirementButton;
        protected AdvancedButton showIfButton;
        protected AdvancedButton showIfNotButton;
        protected AdvancedTextField valueTextField;

        public Requirement(VisibilityRequirementsScreen parent, String name, String desc, @Nullable String valueName, boolean enabled, boolean showIf, Consumer<Boolean> enabledCallback, Consumer<Boolean> showIfCallback, @Nullable Consumer<String> valueCallback, CharacterFilter valueFilter, String valueString) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueName = valueName;
            this.enabledCallback = enabledCallback;
            this.showIfCallback = showIfCallback;
            this.valueCallback = valueCallback;
            this.valueFilter = valueFilter;
            this.enabled = enabled;
            this.showIf = showIf;
            this.valueString = valueString;
            this.init();
        }

        protected void init() {
            String enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
            if (!this.enabled) {
                enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
            }
            this.enableRequirementButton = new AdvancedButton(0, 0, 150, 20, enabledString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    if (this.enabled) {
                        this.enabled = false;
                        this.enabledCallback.accept(false);
                        ((AdvancedButton)press).field_146126_j = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
                    } else {
                        this.enabled = true;
                        this.enabledCallback.accept(true);
                        ((AdvancedButton)press).field_146126_j = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
                    }
                }
            });
            ArrayList<String> descLines = new ArrayList<String>();
            descLines.addAll(Arrays.asList(StringUtils.splitLines((String)this.desc, (String)"%n%")));
            descLines.add("");
            descLines.add(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.toggle.btn.desc", (String[])new String[0]));
            this.enableRequirementButton.setDescription(descLines.toArray(new String[0]));
            this.preRenderTasks.add(() -> this.enableRequirementButton.func_175211_a(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.enableRequirementButton.field_146126_j) + 10));
            this.addButton(this.enableRequirementButton);
            String showIfString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            if (!this.showIf) {
                showIfString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            }
            this.showIfButton = new AdvancedButton(0, 0, 100, 20, showIfString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = true;
                    this.showIfCallback.accept(true);
                    ((AdvancedButton)press).field_146126_j = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
                    this.showIfNotButton.field_146126_j = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
                }
            });
            this.showIfButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfButton);
            String showIfNotString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            if (this.showIf) {
                showIfNotString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            }
            this.showIfNotButton = new AdvancedButton(0, 0, 100, 20, showIfNotString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = false;
                    this.showIfCallback.accept(false);
                    ((AdvancedButton)press).field_146126_j = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
                    this.showIfButton.field_146126_j = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
                }
            });
            this.showIfNotButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfNotButton);
            if (this.valueCallback != null && this.valueName != null) {
                this.hasValue = true;
                this.valueTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 150, 20, true, this.valueFilter);
                this.valueTextField.func_146205_d(true);
                this.valueTextField.func_146195_b(false);
                this.valueTextField.func_146203_f(1000);
                if (this.valueString != null) {
                    this.valueTextField.func_146180_a(this.valueString);
                }
            }
        }

        public void render(int mouseX, int mouseY, RequirementScrollEntry entry) {
            for (Runnable r : this.preRenderTasks) {
                r.run();
            }
            float partial = Minecraft.func_71410_x().func_184121_ak();
            int originX = entry.x + entry.getWidth() / 2;
            int originY = entry.y + entry.getHeight() / 2;
            originY = this.hasValue ? (originY += 23) : (originY += 45);
            this.enableRequirementButton.field_146128_h = originX - this.enableRequirementButton.field_146120_f / 2;
            this.enableRequirementButton.field_146129_i = originY - 70;
            this.showIfButton.field_146128_h = originX - this.showIfButton.field_146120_f - 5;
            this.showIfButton.field_146129_i = originY - 40;
            this.showIfNotButton.field_146124_l = this.enabled;
            this.showIfNotButton.field_146128_h = originX + 5;
            this.showIfNotButton.field_146129_i = originY - 40;
            this.showIfButton.field_146124_l = this.enabled;
            if (this.valueTextField != null) {
                this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.valueName + ":", originX, originY - 10, -1);
                this.valueTextField.field_146209_f = originX - this.valueTextField.func_146200_o() / 2;
                this.valueTextField.field_146210_g = originY + 3;
                this.valueTextField.func_146194_f();
                this.valueTextField.func_146184_c(this.enabled);
                this.valueCallback.accept(this.valueTextField.func_146179_b());
                this.valueString = this.valueTextField.func_146179_b();
            }
            this.renderButtons(mouseX, mouseY, partial);
        }

        protected void renderButtons(int mouseX, int mouseY, float partial) {
            for (AdvancedButton b : this.buttonList) {
                b.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partial);
            }
        }

        protected void addButton(AdvancedButton b) {
            if (!this.buttonList.contains(b)) {
                this.buttonList.add(b);
                UIBase.colorizeButton(b);
            }
        }
    }

    public static class RequirementScrollEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public Requirement requirement;
        public boolean hasValue = false;
        public Color backgroundColor;

        public RequirementScrollEntry(ScrollArea parent, Requirement requirement, Color backgroundColor) {
            super(parent, call -> {});
            this.requirement = requirement;
            this.backgroundColor = backgroundColor;
            if (requirement.valueCallback != null && requirement.valueName != null) {
                this.hasValue = true;
                this.setHeight(110);
            } else {
                this.setHeight(66);
            }
        }

        @Override
        public void renderEntry() {
            super.renderEntry();
            RequirementScrollEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)this.backgroundColor.getRGB());
            this.requirement.render(MouseInput.getMouseX(), MouseInput.getMouseY(), this);
        }
    }
}

