/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import de.keksuccino.loadmyresources.pack.PackHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class LMRFolderResourcePack
extends FolderResourcePack {
    public LMRFolderResourcePack() {
        super(PackHandler.resourcesDirectory);
    }

    public String func_130077_b() {
        return "loadmyresources.hiddenpack";
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return LMRFolderResourcePack.readMetadata(metadataSerializer, Minecraft.func_71410_x().func_110442_L().func_110536_a(PackHandler.DUMMY_PACK_META).func_110527_b(), metadataSectionName);
    }

    private static <T extends IMetadataSection> T readMetadata(MetadataSerializer metadataSerializer, InputStream p_110596_1_, String sectionName) {
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(p_110596_1_, StandardCharsets.UTF_8));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (RuntimeException runtimeexception) {
            try {
                throw new JsonParseException((Throwable)runtimeexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedreader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (T)metadataSerializer.func_110503_a(sectionName, jsonobject);
    }

    public Set<String> func_110587_b() {
        HashSet s = Sets.newHashSet();
        File[] files = this.field_110597_b.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (files != null) {
            for (File f : files) {
                String path = LMRFolderResourcePack.getRelativePath(this.field_110597_b, f);
                if (!path.equals(path.toLowerCase(Locale.ROOT))) continue;
                s.add(path.substring(0, path.length() - 1));
            }
        }
        return s;
    }

    protected static String getRelativePath(File f1, File f2) {
        return f1.toURI().relativize(f2.toURI()).getPath();
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        return this.func_110591_a(LMRFolderResourcePack.getPathFromLocation(location));
    }

    public boolean func_110589_b(ResourceLocation location) {
        return this.func_110593_b(LMRFolderResourcePack.getPathFromLocation(location));
    }

    private static String getPathFromLocation(ResourceLocation location) {
        return String.format("%s/%s", location.func_110624_b(), location.func_110623_a());
    }
}

