/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.event.TextureCollectedEvent;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.model.parsing.ModelLoaderCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private final Set<ResourceLocation> registeredTextures = new HashSet<ResourceLocation>();
    private final Object2BooleanMap<ResourceLocation> wrappedModels = new Object2BooleanLinkedOpenHashMap();
    private static final Class<?> multipartModelClass;
    private static final Class<?> vanillaModelWrapperClass;
    private static final Field multipartPartModels;
    private static final Field modelWrapperModel;

    @SubscribeEvent
    public void onTextureStitch(TextureCollectedEvent event) {
        if (Minecraft.func_71410_x().func_147117_R() != null) {
            TextureAtlasSprite sprite = event.getSprite();
            try {
                ResourceLocation rel = new ResourceLocation(sprite.func_94215_i());
                rel = new ResourceLocation(rel.func_110624_b(), "textures/" + rel.func_110623_a() + ".png");
                IMetadataSectionCTM metadata = ResourceUtil.getMetadata(rel);
                if (metadata != null) {
                    if (metadata.getProxy() != null) {
                        ResourceLocation proxysprite = new ResourceLocation(metadata.getProxy());
                        IMetadataSectionCTM proxymeta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(proxysprite));
                        event.getMap().func_174942_a(proxysprite);
                        if (proxymeta != null) {
                            for (ResourceLocation r : proxymeta.getAdditionalTextures()) {
                                if (!this.registeredTextures.add(r)) continue;
                                event.getMap().func_174942_a(r);
                            }
                        }
                    }
                    for (ResourceLocation r : metadata.getAdditionalTextures()) {
                        if (!this.registeredTextures.add(r)) continue;
                        event.getMap().func_174942_a(r);
                    }
                }
            }
            catch (FileNotFoundException rel) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map stateModels = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"stateModels"});
        for (ModelResourceLocation mrl : event.getModelRegistry().func_148742_b()) {
            IModel rootModel = (IModel)stateModels.get(mrl);
            if (rootModel == null || rootModel instanceof IModelCTM || ModelLoaderCTM.parsedLocations.contains(mrl)) continue;
            ArrayDeque<Object> dependencies = new ArrayDeque<Object>();
            HashSet<Object> seenModels = new HashSet<Object>();
            dependencies.push(mrl);
            seenModels.add(mrl);
            boolean shouldWrap = (Boolean)this.wrappedModels.getOrDefault((Object)mrl, (Object)false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                IModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == mrl ? rootModel : ModelLoaderRegistry.getModel((ResourceLocation)dep);
                }
                catch (Exception e) {
                    continue;
                }
                Set<Object> textures = Sets.newHashSet((Iterable)model.getTextures());
                if (vanillaModelWrapperClass.isAssignableFrom(model.getClass())) {
                    ModelBlock parent = ((ModelBlock)TextureMetadataHandler.modelWrapperModel.get((Object)model)).field_178315_d;
                    while (parent != null) {
                        textures.addAll(parent.field_178318_c.values().stream().filter(s -> !s.startsWith("#")).map(ResourceLocation::new).collect(Collectors.toSet()));
                        parent = parent.field_178315_d;
                    }
                }
                HashSet newDependencies = Sets.newHashSet((Iterable)model.getDependencies());
                if (multipartModelClass.isAssignableFrom(model.getClass())) {
                    Map partModels = (Map)multipartPartModels.get(model);
                    textures = partModels.values().stream().map(m -> m.getTextures()).flatMap(Collection::stream).collect(Collectors.toSet());
                    newDependencies.addAll(partModels.values().stream().flatMap(m -> m.getDependencies().stream()).collect(Collectors.toList()));
                }
                for (ResourceLocation tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                    break;
                }
                for (ResourceLocation rl : newDependencies) {
                    if (!seenModels.add(rl)) continue;
                    dependencies.push(rl);
                }
            }
            this.wrappedModels.put((Object)mrl, shouldWrap);
            if (!shouldWrap) continue;
            try {
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)this.wrap(rootModel, (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
                dependencies.clear();
            }
            catch (IOException e) {
                CTM.logger.error("Could not wrap model " + mrl + ". Aborting...", (Throwable)e);
            }
        }
    }

    @Nonnull
    private IBakedModel wrap(IModel model, IBakedModel object) throws IOException {
        ModelCTM modelchisel = new ModelCTM(null, model, (Int2ObjectMap<JsonElement>)Int2ObjectMaps.emptyMap());
        modelchisel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString()));
        return new ModelBakedCTM(modelchisel, object);
    }

    public void invalidateCaches() {
        this.registeredTextures.clear();
        this.wrappedModels.clear();
    }

    static {
        try {
            multipartModelClass = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            multipartPartModels = multipartModelClass.getDeclaredField("partModels");
            multipartPartModels.setAccessible(true);
            vanillaModelWrapperClass = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            modelWrapperModel = vanillaModelWrapperClass.getDeclaredField("model");
            modelWrapperModel.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

