/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.BlockEntity;
import fossilsarcheology.server.api.IgnoreRenderProperty;
import fossilsarcheology.server.api.SubtypeRenderedItem;
import fossilsarcheology.server.block.IBlockItem;
import fossilsarcheology.server.block.VaseVariant;
import fossilsarcheology.server.block.entity.TileEntityVase;
import fossilsarcheology.server.tab.FATabRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VaseBlock
extends BlockContainer
implements BlockEntity,
IBlockItem,
SubtypeRenderedItem,
IgnoreRenderProperty {
    public static final PropertyEnum<VaseVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", VaseVariant.class);

    protected VaseBlock(String type) {
        super(Material.field_151576_e);
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.func_149663_c("vase_" + type);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)VaseVariant.DAMAGED)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{VARIANT};
    }

    public int func_180651_a(IBlockState state) {
        return ((VaseVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing rotation = placer.func_174811_aO().func_176746_e();
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityVase) {
            TileEntityVase vase = (TileEntityVase)entity;
            vase.setVaseRotation(rotation);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)VaseVariant.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((VaseVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public ItemBlock getItemBlock(Block block) {
        return new VaseItemBlock(block);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    @Override
    public int[] getUsedSubtypes() {
        int[] usedSubtypes = new int[VaseVariant.values().length];
        for (int i = 0; i < usedSubtypes.length; ++i) {
            usedSubtypes[i] = i;
        }
        return usedSubtypes;
    }

    @Override
    public String getResource(ResourceLocation name, int metadata) {
        return name.func_110623_a() + "_" + metadata;
    }

    public class VaseItemBlock
    extends ItemBlock {
        private VaseItemBlock(Block block) {
            super(block);
            this.func_77627_a(true);
        }

        public String func_77667_c(ItemStack stack) {
            return this.func_77658_a() + "." + VaseVariant.get(stack.func_77952_i()).func_176610_l();
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (this.func_194125_a(tab)) {
                for (VaseVariant variant : VaseVariant.values()) {
                    items.add((Object)new ItemStack((Item)this, 1, variant.ordinal()));
                }
            }
        }

        public int func_77647_b(int damage) {
            return damage;
        }
    }
}

