/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import cofh.redstoneflux.api.IEnergyReceiver;
import fossilsarcheology.Revival;
import fossilsarcheology.server.block.AnalyzerBlock;
import fossilsarcheology.server.block.entity.FAEnergyStorage;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux", striprefs=true)
public class TileEntityAnalyzer
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable,
IEnergyReceiver {
    private static final int[] SLOTS_TOP = new int[0];
    private static final int[] SLOTS_BOTTOM = new int[]{9, 10, 11, 12};
    private static final int[] SLOTS_SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public int analyzeFuelTime = 0;
    public int currentFuelTime = 100;
    public int analyzeTime = 0;
    public FAEnergyStorage energyStorage;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private String customName;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)13, (Object)ItemStack.field_190927_a);
    private int rawIndex = -1;

    public TileEntityAnalyzer() {
        this.energyStorage = new FAEnergyStorage(Revival.CONFIG_OPTIONS.machineMaxEnergy, Revival.CONFIG_OPTIONS.machineTransferRate, Revival.CONFIG_OPTIONS.machineTransferRate, 0);
    }

    private static int getFuelTime(ItemStack stack) {
        return 100;
    }

    public static boolean isFuel(ItemStack stack) {
        return TileEntityAnalyzer.getFuelTime(stack) > 0;
    }

    public static boolean isAnalyzable(ItemStack stack) {
        return FAMachineRecipeRegistry.getAnalyzerRecipeForItem(stack) != null;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStackHelper.func_188382_a(this.stacks, (int)slot, (int)amount);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
        this.analyzeFuelTime = compound.func_74765_d("FuelTime");
        this.analyzeTime = compound.func_74765_d("AnalyzeTime");
        this.currentFuelTime = 100;
        if (compound.func_74764_b("CustomName")) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.energyStorage.deserializeNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("FuelTime", (short)this.analyzeFuelTime);
        compound.func_74777_a("AnalyzeTime", (short)this.analyzeTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        NBTTagCompound secondTag = this.energyStorage.serializeNBT();
        compound.func_74768_a("EnergyStored", secondTag.func_74762_e("EnergyStored"));
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getAnalyzeProgressScaled(int scale) {
        return this.analyzeTime * scale / 200;
    }

    public boolean isAnalyzing() {
        return this.analyzeFuelTime > 0;
    }

    public void func_73660_a() {
        if (Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            for (EnumFacing facing : EnumFacing.values()) {
                IEnergyStorage storage;
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) == null || !this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)).hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || (storage = (IEnergyStorage)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)).getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) == null) continue;
                int energy = storage.extractEnergy(Revival.CONFIG_OPTIONS.machineTransferRate, false);
                this.energyStorage.receiveEnergy(energy, false);
            }
        }
        boolean fueled = this.analyzeFuelTime > 0;
        boolean dirty = false;
        if (this.analyzeFuelTime > 0) {
            --this.analyzeFuelTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.analyzeFuelTime == 0 && this.canAnalyze()) {
                this.analyzeFuelTime = 100;
                this.currentFuelTime = 100;
                dirty = true;
            }
            if (this.isAnalyzing() && this.canAnalyze()) {
                ++this.analyzeTime;
                this.energyStorage.extractEnergy(Revival.CONFIG_OPTIONS.machineEnergyUsage, false);
                if (this.analyzeTime == 200) {
                    this.analyzeTime = 0;
                    this.analyzeItem();
                    dirty = true;
                }
            } else {
                this.analyzeTime = 0;
            }
            if (fueled != this.analyzeFuelTime > 0) {
                dirty = true;
                AnalyzerBlock.setState(this.analyzeFuelTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    private boolean canAnalyze() {
        int slot;
        int spaceIndex = -1;
        this.rawIndex = -1;
        boolean hasPower = true;
        if (Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            hasPower = this.energyStorage.energy > 0;
        }
        boolean flag = false;
        for (slot = 0; slot < 9; ++slot) {
            if (((ItemStack)this.stacks.get(slot)).func_190926_b() || !TileEntityAnalyzer.isAnalyzable((ItemStack)this.stacks.get(slot))) continue;
            this.rawIndex = slot;
            flag = true;
            break;
        }
        if (this.rawIndex == -1 || !flag) {
            return false;
        }
        for (slot = 12; slot > 8; --slot) {
            if (!((ItemStack)this.stacks.get(slot)).func_190926_b()) continue;
            spaceIndex = slot;
            break;
        }
        return spaceIndex != -1 && this.rawIndex != -1 && hasPower;
    }

    public void analyzeItem() {
        if (this.canAnalyze()) {
            ItemStack output = ItemStack.field_190927_a;
            Random random = this.field_145850_b.field_73012_v;
            ItemStack input = (ItemStack)this.stacks.get(this.rawIndex);
            output = FAMachineRecipeRegistry.getAnalyzerRecipeForItem(input).generateOutput(new Random());
            if (output.func_190916_E() > 1) {
                int maxCount = output.func_190916_E() - 1;
                output.func_190920_e(1 + random.nextInt(maxCount));
            }
            if (!output.func_190926_b()) {
                for (int slot = 9; slot < 13; ++slot) {
                    ItemStack stack = (ItemStack)this.stacks.get(slot);
                    if (stack.func_190926_b()) {
                        this.stacks.set(slot, (Object)output);
                        break;
                    }
                    if (!stack.func_77969_a(output) || stack.func_190916_E() + output.func_190916_E() >= 64) continue;
                    stack.func_190920_e(stack.func_190916_E() + output.func_190916_E());
                    break;
                }
            }
            input.func_190918_g(1);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 1 || TileEntityAnalyzer.isFuel(stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.analyzeFuelTime;
            }
            case 1: {
                return this.currentFuelTime;
            }
            case 2: {
                return this.analyzeTime;
            }
            case 3: {
                return this.energyStorage.energy;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.analyzeFuelTime = value;
                break;
            }
            case 1: {
                this.currentFuelTime = value;
                break;
            }
            case 2: {
                this.analyzeTime = value;
                break;
            }
            case 3: {
                this.energyStorage.energy = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public void func_174889_b(EntityPlayer player) {
        for (int slots = 12; slots > 8; --slots) {
            if (!((ItemStack)this.stacks.get(slots)).func_190926_b() && ((ItemStack)this.stacks.get(slots)).func_77973_b() != FAItemRegistry.STONE_TABLET) continue;
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 1;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : I18n.func_74838_a((String)"tile.analyzer.name");
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager netManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && Revival.CONFIG_OPTIONS.machinesRequireEnergy) {
            return (T)this.energyStorage;
        }
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            return (T)this.handlerTop;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return Revival.CONFIG_OPTIONS.machinesRequireEnergy;
    }
}

