/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world.gen;

import fossilsarcheology.server.block.FABlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCalamites
extends WorldGenerator {
    private static final IBlockState LOG = FABlockRegistry.CALAMITES_LOG.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
    private static final IBlockState LEAF = FABlockRegistry.CALAMITES_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private boolean keepGenerating = true;

    public static boolean canGenTree(World world, BlockPos pos) {
        for (int y = 0; y <= 30; ++y) {
            if (WorldGenCalamites.isReplaceable(world, pos.func_177981_b(y))) continue;
            return false;
        }
        return true;
    }

    private static boolean isReplaceable(World world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || world.func_180495_p(pos).func_177230_c() == FABlockRegistry.CALAMITES_SAPLING;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Block j1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        this.keepGenerating = true;
        if (j1 != Blocks.field_150349_c && j1 != Blocks.field_150346_d || pos.func_177956_o() >= 115) {
            return false;
        }
        int treeHeight = 15 + rand.nextInt(15);
        BlockPos canopyCenter = pos.func_177981_b(rand.nextInt(1) + 1);
        int minWidth = 2;
        int maxWidth = 4;
        float widthStep = (float)(maxWidth - minWidth) / (float)treeHeight;
        while (canopyCenter.func_177956_o() < pos.func_177981_b(treeHeight - 1).func_177956_o()) {
            int difference = pos.func_177981_b(treeHeight).func_177956_o() - canopyCenter.func_177956_o();
            float canopyWidth = (float)minWidth + widthStep * (float)difference;
            canopyCenter = canopyCenter.func_177981_b(4);
            this.genCircle(world, canopyCenter, canopyWidth - 2.0f, false);
            this.genCircle(world, canopyCenter.func_177984_a(), canopyWidth - 1.0f, false);
            if (difference > 4) {
                this.genCircle(world, canopyCenter.func_177981_b(2), canopyWidth, true);
                this.genCircle(world, canopyCenter.func_177981_b(3), canopyWidth + 1.0f, true);
                this.setBlockState(world, canopyCenter.func_177978_c(), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Z));
                this.setBlockState(world, canopyCenter.func_177976_e(), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.X));
                this.setBlockState(world, canopyCenter.func_177974_f(), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.X));
                this.setBlockState(world, canopyCenter.func_177968_d(), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Z));
                continue;
            }
            this.setBlockState(world, canopyCenter, LOG);
            this.setBlockState(world, canopyCenter.func_177984_a(), LOG);
            this.setBlockState(world, canopyCenter.func_177977_b(), LOG);
        }
        for (int y = pos.func_177956_o() - 1 + 1; y <= pos.func_177956_o() + treeHeight; ++y) {
            this.setBlockState(world, new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), LOG);
        }
        return true;
    }

    private void genCircle(World world, BlockPos pos, float size, boolean spikes) {
        float f = size;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177963_a((double)(-size), 0.0, (double)(-size)), (BlockPos)pos.func_177963_a((double)size, 0.0, (double)size))) {
            boolean corner;
            int distanceX = Math.abs(blockpos.func_177958_n() - pos.func_177958_n());
            int distanceZ = Math.abs(blockpos.func_177952_p() - pos.func_177952_p());
            boolean bl = corner = blockpos.func_177958_n() == pos.func_177958_n() || blockpos.func_177952_p() == pos.func_177952_p() || distanceX == distanceZ;
            if (spikes) {
                if (!corner || !(blockpos.func_177951_i((Vec3i)pos) > (double)(f - 1.0f) * (double)(f - 1.0f)) || !(blockpos.func_177951_i((Vec3i)pos) <= (double)(f * f))) continue;
                this.setBlockState(world, blockpos, LEAF);
                continue;
            }
            if (!(blockpos.func_177951_i((Vec3i)pos) <= (double)(f * f))) continue;
            this.setBlockState(world, blockpos, LEAF);
        }
    }

    public void setBlockState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state);
    }
}

