/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.mixin.launch;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import io.github.lxgaming.classloader.ClassLoaderUtils;
import io.github.lxgaming.mixin.launch.MixinClassLoader;
import io.github.lxgaming.mixin.launch.MixinTransformationService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MixinBootstrap {
    public static final String ID = "mixinbootstrap";
    public static final String NAME = "MixinBootstrap";
    public static final String VERSION = "1.1.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBootstrap Launch");

    public static void initialize(IEnvironment environment) {
        MixinBootstrap.ensureTransformerExclusion();
    }

    public static void onLoad(IEnvironment environment, MixinTransformationService service) throws IncompatibleEnvironmentException {
        if (environment.findLaunchPlugin("mixin").isPresent()) {
            LOGGER.debug("MixinLaunchPlugin detected");
            return;
        }
        if (IEnvironment.class.getPackage().isCompatibleWith("8.0")) {
            MixinBootstrap.setFallbackClassLoader(service.getClass().getClassLoader());
            service.registerLaunchPluginService("org.spongepowered.asm.launch.MixinLaunchPlugin", MixinBootstrap.class.getClassLoader());
            service.registerTransformationService("org.spongepowered.asm.launch.MixinTransformationService", MixinBootstrap.class.getClassLoader());
            return;
        }
        if (IEnvironment.class.getPackage().isCompatibleWith("4.0")) {
            MixinBootstrap.appendToClassPath();
            service.registerLaunchPluginService("org.spongepowered.asm.launch.MixinLaunchPluginLegacy", Launcher.class.getClassLoader());
            service.registerTransformationService("org.spongepowered.asm.launch.MixinTransformationServiceLegacy", Thread.currentThread().getContextClassLoader());
            service.registerLaunchPluginService("io.github.lxgaming.mixin.launch.MixinLaunchPluginService", Launcher.class.getClassLoader());
            return;
        }
        LOGGER.error("-------------------------[ ERROR ]-------------------------");
        LOGGER.error("Mixin is not compatible with ModLauncher v{}", (Object)ITransformationService.class.getPackage().getImplementationVersion());
        LOGGER.error("Ensure you are running Forge v28.1.45 or later");
        LOGGER.error("-------------------------[ ERROR ]-------------------------");
        throw new IncompatibleEnvironmentException("Incompatibility with ModLauncher");
    }

    private static void appendToClassPath() throws IncompatibleEnvironmentException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("create", "true");
            FileSystem fileSystem = FileSystems.newFileSystem(URI.create("jar:" + MixinBootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI()), map);
            Map<Path, String> libraries = Files.list(fileSystem.getPath("META-INF", "libraries")).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar")).collect(Collectors.toMap(path -> path, path -> {
                String fileName = path.getFileName().toString();
                int index = fileName.lastIndexOf(46);
                return index != -1 ? fileName.substring(0, index) : fileName;
            }));
            LOGGER.debug("Found {} libraries", (Object)libraries.size());
            for (Map.Entry<Path, String> entry : libraries.entrySet()) {
                Path temporaryPath = Files.createTempFile("mixinbootstrap-" + entry.getValue() + "-", ".jar", new FileAttribute[0]);
                LOGGER.debug("Copying {} -> {}", (Object)entry.getKey(), (Object)temporaryPath);
                Files.copy(entry.getKey(), temporaryPath, StandardCopyOption.REPLACE_EXISTING);
                URL url = temporaryPath.toUri().toURL();
                LOGGER.debug("Loading {}", (Object)url);
                ClassLoaderUtils.appendToClassPath(Thread.currentThread().getContextClassLoader(), url);
            }
            URL url = MixinBootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI().toURL();
            LOGGER.debug("Loading {}", (Object)url);
            ClassLoaderUtils.appendToClassPath(Thread.currentThread().getContextClassLoader(), url);
        }
        catch (Throwable ex) {
            LOGGER.error("Encountered an error while appending to the class path", ex);
            throw new IncompatibleEnvironmentException("Failed to append to the class path");
        }
    }

    private static void setFallbackClassLoader(ClassLoader classLoader) throws IncompatibleEnvironmentException {
        try {
            Class<?> moduleClassLoaderClass = Class.forName("cpw.mods.cl.ModuleClassLoader");
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (!moduleClassLoaderClass.isInstance(contextClassLoader) || classLoader.equals(contextClassLoader)) {
                throw new IllegalStateException("Unexpected ClassLoader: " + contextClassLoader.getClass().getName());
            }
            Method getPlatformClassLoaderMethod = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
            getPlatformClassLoaderMethod.setAccessible(true);
            ClassLoader platformClassLoader = (ClassLoader)getPlatformClassLoaderMethod.invoke(null, new Object[0]);
            Method setFallbackClassLoaderMethod = moduleClassLoaderClass.getMethod("setFallbackClassLoader", ClassLoader.class);
            setFallbackClassLoaderMethod.setAccessible(true);
            setFallbackClassLoaderMethod.invoke((Object)contextClassLoader, new MixinClassLoader(platformClassLoader, classLoader));
        }
        catch (Throwable ex) {
            LOGGER.error("Encountered an error while setting fallback classloader", ex);
            throw new IncompatibleEnvironmentException("Failed to set fallback classloader");
        }
    }

    private static void ensureTransformerExclusion() {
        try {
            Path path = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).map(parentPath -> parentPath.resolve("mods")).map(Path::toAbsolutePath).map(Path::normalize).map(parentPath -> {
                String file = MixinBootstrap.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                return parentPath.resolve(file.substring(file.lastIndexOf(47) + 1));
            }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(null);
            if (path == null) {
                return;
            }
            if (path.equals(path.toRealPath(new LinkOption[0]))) {
                return;
            }
            Class<?> modDirTransformerDiscovererClass = Class.forName("net.minecraftforge.fml.loading.ModDirTransformerDiscoverer", true, Launcher.class.getClassLoader());
            Field transformersField = modDirTransformerDiscovererClass.getDeclaredField("transformers");
            transformersField.setAccessible(true);
            List transformers = (List)transformersField.get(null);
            if (transformers != null && !transformers.contains(path)) {
                transformers.add(path);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Encountered an error while getting ensuring transformer exclusion", ex);
        }
    }

    static {
        LOGGER.info("{} v{}", (Object)NAME, (Object)VERSION);
        LOGGER.info("Mixin v{}", (Object)"0.8.4");
        LOGGER.info("ModLauncher v{} ({})", (Object)IEnvironment.class.getPackage().getImplementationVersion(), (Object)IEnvironment.class.getPackage().getSpecificationVersion());
    }
}

