/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.world;

import com.google.common.collect.Sets;
import com.mrcrayfish.guns.entity.DamageSourceProjectile;
import com.mrcrayfish.guns.entity.EntityProjectile;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ProjectileExplosion
extends Explosion {
    private final World world;
    private final Entity projectile;
    private final Entity shooter;
    private final ItemStack weapon;
    private float damage;
    private final double x;
    private final double y;
    private final double z;
    private double radius;

    public ProjectileExplosion(EntityProjectile projectile, double x, double y, double z, double radius, boolean damagesTerrain) {
        super(projectile.field_70170_p, (Entity)projectile.getShooter(), x, y, z, (float)(radius * 2.0), false, damagesTerrain);
        this.world = projectile.field_70170_p;
        this.projectile = projectile;
        this.shooter = projectile.getShooter();
        this.weapon = projectile.getWeapon();
        this.damage = projectile.getDamage();
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public ProjectileExplosion(World world, Entity shooter, Entity source, ItemStack weapon, double x, double y, double z, float damage, double radius, boolean damagesTerrain) {
        super(world, shooter, x, y, z, (float)(radius * 2.0), false, damagesTerrain);
        this.world = world;
        this.projectile = source;
        this.shooter = shooter;
        this.weapon = weapon;
        this.damage = damage;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public void func_77278_a() {
        float size = (float)(this.radius * 2.0);
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double posX = this.x;
                    double posY = this.y;
                    double posZ = this.z;
                    float f1 = 0.3f;
                    for (float f = size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.225f) {
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float resistance = this.shooter != null ? this.shooter.func_180428_a((Explosion)this, this.world, pos, state) : state.func_177230_c().getExplosionResistance(this.world, pos, null, (Explosion)this);
                            f -= (resistance + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.shooter == null || this.shooter.func_174816_a((Explosion)this, this.world, pos, state, f))) {
                            set.add(pos);
                        }
                        posX += d0 * 0.3;
                        posY += d1 * 0.3;
                        posZ += d2 * 0.3;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        int minX = MathHelper.func_76128_c((double)(this.x - this.radius));
        int maxX = MathHelper.func_76128_c((double)(this.x + this.radius));
        int minY = MathHelper.func_76128_c((double)(this.y - this.radius));
        int maxY = MathHelper.func_76128_c((double)(this.y + this.radius));
        int minZ = MathHelper.func_76128_c((double)(this.z - this.radius));
        int maxZ = MathHelper.func_76128_c((double)(this.z + this.radius));
        List list = this.world.func_72872_a(Entity.class, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3d vec3d = new Vec3d(this.x, this.y, this.z);
        for (Entity entity : list) {
            EntityPlayer entityplayer;
            double deltaZ;
            double deltaY;
            double deltaX;
            double deltaDistance;
            double distanceToExplosion;
            if (entity.func_180427_aV() || !((distanceToExplosion = entity.func_70011_f(this.x, this.y, this.z)) <= this.radius) || (deltaDistance = (double)MathHelper.func_76133_a((double)((deltaX = entity.field_70165_t - this.x) * deltaX + (deltaY = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * deltaY + (deltaZ = entity.field_70161_v - this.z) * deltaZ))) == 0.0) continue;
            deltaX /= deltaDistance;
            deltaY /= deltaDistance;
            deltaZ /= deltaDistance;
            double density = this.world.func_72842_a(vec3d, entity.func_174813_aQ());
            double damage = (this.radius - distanceToExplosion) / this.radius * density;
            entity.func_70097_a((DamageSource)new DamageSourceProjectile("bullet", this.projectile, this.shooter, this.weapon), (float)(damage * (double)this.damage));
            double motion = damage;
            if (entity instanceof EntityLivingBase) {
                motion = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
            }
            entity.field_70159_w += deltaX * motion;
            entity.field_70181_x += deltaY * motion;
            entity.field_70179_y += deltaZ * motion;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(entityplayer, new Vec3d(deltaX * damage, deltaY * damage, deltaZ * damage));
        }
    }
}

