/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.google.common.base.Optional;
import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.entities.EntityCorpseInventoryBase;
import de.maxhenkel.corpse.proxy.CommonProxy;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCorpse
extends EntityCorpseInventoryBase {
    private static final DataParameter<Optional<UUID>> ID = EntityDataManager.func_187226_a(EntityCorpse.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityCorpse.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityCorpse.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityCorpse.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final AxisAlignedBB NULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final UUID NULL_UUID = new UUID(0L, 0L);
    private AxisAlignedBB boundingBox;

    public EntityCorpse(World world) {
        super(world);
        this.field_70130_N = 2.0f;
        this.field_70131_O = 0.5f;
        this.boundingBox = NULL_AABB;
        this.field_70156_m = true;
    }

    public static EntityCorpse createFromDeath(EntityPlayer player, Death death) {
        EntityCorpse corpse = new EntityCorpse(player.field_70170_p);
        corpse.setCorpseUUID(death.getPlayerUUID());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setItems(death.getItems());
        corpse.func_70107_b(death.getPosX(), death.getPosY() < 0.0 ? 0.0 : death.getPosY(), death.getPosZ());
        corpse.setCorpseRotation(player.field_70177_z);
        return corpse;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.recalculateBoundingBox();
        this.setCorpseAge(this.getCorpseAge() + 1);
        this.field_70181_x = !this.field_70124_G && this.field_70163_u > 0.0 ? Math.max(-2.0, this.field_70181_x - 0.0625) : 0.0;
        if (this.field_70163_u < 0.0) {
            this.func_70634_a(this.field_70165_t, 0.0, this.field_70161_v);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_191420_l() && this.field_70173_aa > 200) {
            this.func_70106_y();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            boolean isOp;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!(!CommonProxy.onlyOwnerAccess || (isOp = playerMP.func_70003_b(playerMP.field_71133_b.func_110455_j(), "op")) && playerMP.func_110124_au().equals(this.getCorpseUUID()))) {
                return true;
            }
        }
        BlockPos pos = this.func_180425_c();
        player.openGui((Object)"corpse", 0, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void recalculateBoundingBox() {
        EnumFacing facing = this.field_70180_af == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)this.getCorpseRotation());
        this.boundingBox = new AxisAlignedBB(this.field_70165_t - (facing.func_82601_c() != 0 ? 1.0 : 0.5), this.field_70163_u, this.field_70161_v - (facing.func_82599_e() != 0 ? 1.0 : 0.5), this.field_70165_t + (facing.func_82601_c() != 0 ? 1.0 : 0.5), this.field_70163_u + 0.5, this.field_70161_v + (facing.func_82599_e() != 0 ? 1.0 : 0.5));
    }

    public ITextComponent func_145748_c_() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation("entity.corpse.corpse_of", new Object[]{this.getCorpseName()});
    }

    public boolean func_90999_ad() {
        return false;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.boundingBox;
    }

    public void func_174826_a(AxisAlignedBB bb) {
        this.boundingBox = bb;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.recalculateBoundingBox();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public UUID getCorpseUUID() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(ID);
        if (uuid.isPresent()) {
            return (UUID)uuid.get();
        }
        return NULL_UUID;
    }

    public void setCorpseUUID(UUID uuid) {
        if (uuid == null) {
            this.field_70180_af.func_187227_b(ID, (Object)Optional.of((Object)NULL_UUID));
        } else {
            this.field_70180_af.func_187227_b(ID, (Object)Optional.of((Object)uuid));
        }
    }

    public String getCorpseName() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setCorpseName(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
    }

    public float getCorpseRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setCorpseRotation(float rotation) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rotation));
        this.recalculateBoundingBox();
    }

    public int getCorpseAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setCorpseAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID, (Object)Optional.of((Object)NULL_UUID));
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        UUID uuid = this.getCorpseUUID();
        if (uuid != null) {
            compound.func_74772_a("IDMost", uuid.getMostSignificantBits());
            compound.func_74772_a("IDLeast", uuid.getLeastSignificantBits());
        }
        compound.func_74778_a("Name", this.getCorpseName());
        compound.func_74776_a("Rotation", this.getCorpseRotation());
        compound.func_74768_a("Age", this.getCorpseAge());
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("IDMost") && compound.func_74764_b("IDLeast")) {
            this.setCorpseUUID(new UUID(compound.func_74763_f("IDMost"), compound.func_74763_f("IDLeast")));
        }
        this.setCorpseName(compound.func_74779_i("Name"));
        this.setCorpseRotation(compound.func_74760_g("Rotation"));
        this.setCorpseAge(compound.func_74762_e("Age"));
    }
}

