/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.ConfigEntry;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class ConfigScreen
extends GuiScreen {
    protected Config config;
    protected ScrollArea configList;
    protected GuiScreen parent;
    protected String title;
    protected AdvancedButton doneBtn;
    protected String activeDescription = null;
    protected Map<String, String> descriptions = new HashMap<String, String>();
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);

    public ConfigScreen(Config config, String title, GuiScreen parent) {
        this.config = config;
        this.parent = parent;
        this.title = title;
        this.configList = new ScrollArea(0, 50, 300, 0);
        this.configList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        for (String s : this.config.getCategorys()) {
            this.configList.addEntry(new CategoryConfigScrollAreaEntry(this.configList, s));
            for (ConfigEntry e : this.config.getEntrysForCategory(s)) {
                if (e.getType() == ConfigEntry.EntryType.STRING) {
                    this.configList.addEntry(new StringConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.INTEGER) {
                    this.configList.addEntry(new IntegerConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.DOUBLE) {
                    this.configList.addEntry(new DoubleConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.FLOAT) {
                    this.configList.addEntry(new FloatConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.LONG) {
                    this.configList.addEntry(new LongConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() != ConfigEntry.EntryType.BOOLEAN) continue;
                this.configList.addEntry(new BooleanConfigScrollAreaEntry(this.configList, e));
            }
        }
        this.doneBtn = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.done", new String[0]), true, press -> Minecraft.func_71410_x().func_147108_a(this.parent));
        ConfigScreen.colorizeButton(this.doneBtn);
        this.doneBtn.ignoreBlockedInput = true;
        this.doneBtn.ignoreLeftMouseDownClickBlock = true;
    }

    public void func_73866_w_() {
        this.configList.x = this.field_146294_l / 2 - 150;
        this.configList.height = this.field_146295_m - 100;
    }

    public void func_146281_b() {
        this.saveConfig();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179147_l();
        ConfigScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        this.configList.render();
        ConfigScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        if (this.title != null) {
            this.func_73731_b(font, this.title, this.field_146294_l / 2 - font.func_78256_a(this.title) / 2, 20, Color.WHITE.getRGB());
        }
        ConfigScreen.func_73734_a((int)0, (int)(this.field_146295_m - 50), (int)this.field_146294_l, (int)this.field_146295_m, (int)HEADER_FOOTER_COLOR.getRGB());
        this.doneBtn.field_146128_h = this.field_146294_l / 2 - this.doneBtn.field_146120_f / 2;
        this.doneBtn.field_146129_i = this.field_146295_m - 35;
        this.doneBtn.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            String name;
            if (!(e instanceof ConfigScrollAreaEntry) || !e.isHovered() || !this.descriptions.containsKey(name = ((ConfigScrollAreaEntry)e).configEntry.getName())) continue;
            if (ConfigScrollAreaEntry.isHeaderFooterHovered()) break;
            ConfigScreen.renderDescription(this.descriptions.get(name), mouseX, mouseY);
            break;
        }
    }

    public void setValueDescription(String valueName, String desc) {
        this.descriptions.put(valueName, desc);
    }

    public void setCategoryDisplayName(String categoryName, String displayName) {
        CategoryConfigScrollAreaEntry e = this.getCategoryEntryByName(categoryName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    public void setValueDisplayName(String valueName, String displayName) {
        ConfigScrollAreaEntry e = this.getEntryByValueName(valueName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    protected ConfigScrollAreaEntry getEntryByValueName(String valueName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry) || !((ConfigScrollAreaEntry)e).configEntry.getName().equals(valueName)) continue;
            return (ConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected CategoryConfigScrollAreaEntry getCategoryEntryByName(String categoryName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof CategoryConfigScrollAreaEntry) || !((CategoryConfigScrollAreaEntry)e).category.equals(categoryName)) continue;
            return (CategoryConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected void saveConfig() {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry)) continue;
            ((ConfigScrollAreaEntry)e).onSave();
        }
        this.config.syncConfig();
    }

    protected static void renderDescription(String description, int mouseX, int mouseY) {
        if (description != null) {
            String[] desc;
            int width = 10;
            int height = 10;
            for (String s : desc = StringUtils.splitLines(description, "%n%")) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_146294_l < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_146295_m < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre(600);
            ConfigScreen.renderDescriptionBackground(mouseX, mouseY, width, height);
            GlStateManager.func_179147_l();
            int i2 = 5;
            for (String s : desc) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(mouseX + 5), (float)(mouseY + i2), Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost();
            GlStateManager.func_179084_k();
        }
    }

    protected static void renderDescriptionBackground(int x, int y, int width, int height) {
        ConfigScreen.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    protected static class CategoryConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected String category;
        protected FontRenderer font;
        protected String displayName;

        public CategoryConfigScrollAreaEntry(ScrollArea parent, String category) {
            super(parent);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.category = category;
        }

        @Override
        public void renderEntry() {
            int center = this.x + this.getWidth() / 2;
            CategoryConfigScrollAreaEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.font.func_78256_a(this.displayName);
                this.func_73731_b(this.font, this.displayName, center - nameWidth / 2, this.y + 10, Color.WHITE.getRGB());
            } else {
                int nameWidth = this.font.func_78256_a(this.category);
                this.func_73731_b(this.font, this.category, center - nameWidth / 2, this.y + 10, Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 30;
        }
    }

    protected static class BooleanConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedButton toggleBtn;
        private boolean state = false;

        public BooleanConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            if (configEntry.getValue().equalsIgnoreCase("true")) {
                this.state = true;
            }
            this.toggleBtn = new AdvancedButton(0, 0, 102, 20, "", true, press -> {
                if (!BooleanConfigScrollAreaEntry.isHeaderFooterHovered()) {
                    this.state = !this.state;
                    this.toggleBtn.field_146126_j = this.state ? "\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]) : "\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]);
                }
            });
            this.toggleBtn.field_146126_j = this.state ? "\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]) : "\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]);
            ConfigScreen.colorizeButton(this.toggleBtn);
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.toggleBtn.field_146128_h = center + 9;
            this.toggleBtn.field_146129_i = this.y + 3;
            this.toggleBtn.func_191745_a(Minecraft.func_71410_x(), MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_184121_ak());
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue("" + this.state);
        }
    }

    protected static class FloatConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public FloatConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.func_146203_f(10000);
            this.input.func_146180_a(configEntry.getValue());
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.input.field_146209_f = center + 10;
            this.input.field_146210_g = this.y + 3;
            this.input.func_146194_f();
        }

        @Override
        protected void onSave() {
            if (MathUtils.isFloat(this.input.func_146179_b())) {
                this.configEntry.setValue(this.input.func_146179_b());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.func_146179_b());
                System.out.println("Variable Type: FLOAT");
                System.out.println("##################################################");
            }
        }
    }

    protected static class LongConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public LongConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.func_146203_f(10000);
            this.input.func_146180_a(configEntry.getValue());
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.input.field_146209_f = center + 10;
            this.input.field_146210_g = this.y + 3;
            this.input.func_146194_f();
        }

        @Override
        protected void onSave() {
            if (MathUtils.isLong(this.input.func_146179_b())) {
                this.configEntry.setValue(this.input.func_146179_b());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.func_146179_b());
                System.out.println("Variable Type: LONG");
                System.out.println("##################################################");
            }
        }
    }

    protected static class DoubleConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public DoubleConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.func_146203_f(10000);
            this.input.func_146180_a(configEntry.getValue());
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.input.field_146209_f = center + 10;
            this.input.field_146210_g = this.y + 3;
            this.input.func_146194_f();
        }

        @Override
        protected void onSave() {
            if (MathUtils.isDouble(this.input.func_146179_b())) {
                this.configEntry.setValue(this.input.func_146179_b());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.func_146179_b());
                System.out.println("Variable Type: DOUBLE");
                System.out.println("##################################################");
            }
        }
    }

    protected static class IntegerConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public IntegerConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.func_146203_f(10000);
            this.input.func_146180_a(configEntry.getValue());
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.input.field_146209_f = center + 10;
            this.input.field_146210_g = this.y + 3;
            this.input.func_146194_f();
        }

        @Override
        protected void onSave() {
            if (MathUtils.isInteger(this.input.func_146179_b())) {
                this.configEntry.setValue(this.input.func_146179_b());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.func_146179_b());
                System.out.println("Variable Type: INTEGER");
                System.out.println("##################################################");
            }
        }
    }

    protected static class StringConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public StringConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, null);
            this.input.func_146203_f(10000);
            this.input.func_146180_a(configEntry.getValue());
        }

        @Override
        public void render() {
            super.render();
            int center = this.x + this.getWidth() / 2;
            this.input.field_146209_f = center + 10;
            this.input.field_146210_g = this.y + 3;
            this.input.func_146194_f();
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue(this.input.func_146179_b());
        }
    }

    protected static abstract class ConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected ConfigEntry configEntry;
        protected FontRenderer font;
        protected String displayName;

        public ConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.configEntry = configEntry;
        }

        @Override
        public void renderEntry() {
            int center = this.x + this.getWidth() / 2;
            ConfigScrollAreaEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.font.func_78256_a(this.displayName);
                this.func_73731_b(this.font, this.displayName, center - nameWidth - 10, this.y + 10, Color.WHITE.getRGB());
            } else {
                int nameWidth = this.font.func_78256_a(this.configEntry.getName());
                this.func_73731_b(this.font, this.configEntry.getName(), center - nameWidth - 10, this.y + 10, Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 26;
        }

        protected abstract void onSave();

        public static boolean isHeaderFooterHovered() {
            GuiScreen s = Minecraft.func_71410_x().field_71462_r;
            if (s != null) {
                int mouseX = MouseInput.getMouseX();
                int mouseY = MouseInput.getMouseY();
                int minXHeaderFooter = 0;
                int maxXHeaderFooter = s.field_146294_l;
                int minYHeader = 0;
                int maxYHeader = 50;
                int minYFooter = s.field_146295_m - 50;
                int maxYFooter = s.field_146295_m;
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYHeader && mouseY <= maxYHeader) {
                    return true;
                }
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYFooter && mouseY <= maxYFooter) {
                    return true;
                }
            }
            return false;
        }
    }
}

