/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationData;
import de.keksuccino.fancymenu.menu.animation.AnimationHandlerEvents;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class AnimationHandler {
    private static Map<String, AnimationData> animations = new HashMap<String, AnimationData>();
    private static List<String> custom = new ArrayList<String>();
    protected static boolean ready = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AnimationHandlerEvents());
    }

    public static void registerAnimation(IAnimationRenderer animation, String name, AnimationData.Type type) {
        if (!animations.containsKey(name)) {
            animations.put(name, new AnimationData(animation, name, type));
            if (type == AnimationData.Type.EXTERNAL) {
                custom.add(name);
            }
        } else {
            FancyMenu.LOGGER.error("[FANCYMENU] AnimationHandler: ERROR: Duplicate animation name: " + name);
        }
    }

    public static void unregisterAnimation(IAnimationRenderer animation) {
        AnimationData d = null;
        for (AnimationData a : animations.values()) {
            if (a.animation != animation) continue;
            d = a;
            break;
        }
        if (d != null) {
            AnimationHandler.unregisterAnimation(d.name);
        }
    }

    public static void unregisterAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            animations.remove(name);
            if (custom.contains(name)) {
                custom.remove(name);
            }
        }
    }

    public static void loadCustomAnimations() {
        File f = FancyMenu.getAnimationPath();
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        ready = false;
        AnimationHandler.clearCustomAnimations();
        for (File a : f.listFiles()) {
            File audio2;
            File audio1;
            List mainFrameSecs;
            String replayString;
            String loopString;
            PropertiesSection m;
            List metas;
            PropertiesSet props;
            File p;
            String name = null;
            String mainAudio = null;
            String introAudio = null;
            int fps = 0;
            boolean loop = true;
            boolean width = false;
            boolean height = false;
            boolean x = false;
            boolean y = false;
            boolean replayIntro = false;
            ArrayList<String> frameNamesMain = new ArrayList<String>();
            ArrayList<String> frameNamesIntro = new ArrayList<String>();
            String resourceNamespace = null;
            if (!a.isDirectory() || !(p = new File(a.getAbsolutePath() + "/animation.properties")).exists() || (props = PropertiesSerializer.getProperties((String)p.getPath())) == null || (metas = props.getPropertiesOfType("animation-meta")).isEmpty() || (name = (m = (PropertiesSection)metas.get(0)).getEntryValue("name")) == null) continue;
            String fpsString = m.getEntryValue("fps");
            if (fpsString != null && MathUtils.isInteger((String)fpsString)) {
                fps = Integer.parseInt(fpsString);
            }
            if ((loopString = m.getEntryValue("loop")) != null && loopString.equalsIgnoreCase("false")) {
                loop = false;
            }
            if ((replayString = m.getEntryValue("replayintro")) != null && replayString.equalsIgnoreCase("true")) {
                replayIntro = true;
            }
            if ((resourceNamespace = m.getEntryValue("namespace")) == null || (mainFrameSecs = props.getPropertiesOfType("frames-main")).isEmpty()) continue;
            PropertiesSection mainFrames = (PropertiesSection)mainFrameSecs.get(0);
            Map mainFramesMap = mainFrames.getEntries();
            ArrayList mainFrameKeys = new ArrayList();
            for (Map.Entry me : mainFramesMap.entrySet()) {
                String frameNumber;
                if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("[_]", 2)[1]))) continue;
                mainFrameKeys.add(me.getKey());
            }
            Collections.sort(mainFrameKeys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int i2;
                    String n1 = o1.split("[_]", 2)[1];
                    String n2 = o2.split("[_]", 2)[1];
                    int i1 = Integer.parseInt(n1);
                    if (i1 > (i2 = Integer.parseInt(n2))) {
                        return 1;
                    }
                    if (i1 < i2) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (String s : mainFrameKeys) {
                frameNamesMain.add("frames_main/" + (String)mainFramesMap.get(s));
            }
            List introFrameSecs = props.getPropertiesOfType("frames-intro");
            if (!introFrameSecs.isEmpty()) {
                PropertiesSection introFrames = (PropertiesSection)introFrameSecs.get(0);
                Map introFramesMap = introFrames.getEntries();
                ArrayList introFrameKeys = new ArrayList();
                for (Map.Entry me : introFramesMap.entrySet()) {
                    String frameNumber;
                    if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("[_]", 2)[1]))) continue;
                    introFrameKeys.add(me.getKey());
                }
                Collections.sort(introFrameKeys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int i2;
                        String n1 = o1.split("[_]", 2)[1];
                        String n2 = o2.split("[_]", 2)[1];
                        int i1 = Integer.parseInt(n1);
                        if (i1 > (i2 = Integer.parseInt(n2))) {
                            return 1;
                        }
                        if (i1 < i2) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (String s : introFrameKeys) {
                    frameNamesIntro.add("frames_intro/" + (String)introFramesMap.get(s));
                }
            }
            if ((audio1 = new File(a.getAbsolutePath() + "/audio/mainaudio.wav")).exists()) {
                mainAudio = audio1.getPath();
            }
            if ((audio2 = new File(a.getAbsolutePath() + "/audio/introaudio.wav")).exists()) {
                introAudio = audio2.getPath();
            }
            if (name == null) continue;
            File gifIntro = new File(a.getPath() + "/intro.gif");
            File gifAni = new File(a.getPath() + "/animation.gif");
            ResourcePackAnimationRenderer in = null;
            ResourcePackAnimationRenderer an = null;
            if (!frameNamesIntro.isEmpty() && !frameNamesMain.isEmpty()) {
                in = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesIntro, fps, loop, 0, 0, 100, 100);
                an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
            } else if (!frameNamesMain.isEmpty()) {
                an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
            }
            try {
                AdvancedAnimation ani;
                if (in != null && an != null) {
                    ani = new AdvancedAnimation(in, an, introAudio, mainAudio, replayIntro);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.registerAnimation(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    FancyMenu.LOGGER.info("[FANCYMENU] AnimationHandler: Animation registered: " + name + "");
                    continue;
                }
                if (an != null) {
                    ani = new AdvancedAnimation(null, an, introAudio, mainAudio, false);
                    ani.propertiesPath = a.getPath();
                    AnimationHandler.registerAnimation(ani, name, AnimationData.Type.EXTERNAL);
                    ani.prepareAnimation();
                    FancyMenu.LOGGER.info("[FANCYMENU] AnimationHandler: Animation registered: " + name + "");
                    continue;
                }
                FancyMenu.LOGGER.error("[FANCYMENU] AnimationHandler: ERROR: This is not a valid animation: " + name);
            }
            catch (AnimationNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getCustomAnimationNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(custom);
        return l;
    }

    private static String getIntroPath(String path) {
        File f = new File(path + "/intro");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static String getAnimationPath(String path) {
        File f = new File(path + "/animation");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static void clearCustomAnimations() {
        for (String s : custom) {
            if (!animations.containsKey(s)) continue;
            animations.remove(s);
        }
    }

    private static Map<String, String> parseProperties(File prop) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (prop.exists() && prop.isFile()) {
            for (String s : FileUtils.getFileLines((File)prop)) {
                if (!s.contains("=")) continue;
                String name = s.split("[=]", 2)[0].replace(" ", "");
                String value = s.split("[=]", 2)[1].replace(" ", "");
                m.put(name, value);
            }
        }
        return m;
    }

    public static boolean animationExists(String name) {
        return animations.containsKey(name);
    }

    public static List<IAnimationRenderer> getAnimations() {
        ArrayList<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
        for (Map.Entry<String, AnimationData> m : animations.entrySet()) {
            renderers.add(m.getValue().animation);
        }
        return renderers;
    }

    public static IAnimationRenderer getAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            return AnimationHandler.animations.get((Object)name).animation;
        }
        return null;
    }

    public static void resetAnimations() {
        for (AnimationData d : animations.values()) {
            d.animation.resetAnimation();
        }
    }

    public static void resetAnimationSounds() {
        for (AnimationData d : animations.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).resetAudio();
        }
    }

    public static void stopAnimationSounds() {
        for (AnimationData d : animations.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).stopAudio();
        }
    }

    public static boolean isReady() {
        return ready;
    }

    public static void setupAnimationSizes() {
        for (IAnimationRenderer a : AnimationHandler.getAnimations()) {
            IAnimationRenderer intro;
            if (a instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)a).setupAnimationSize();
                continue;
            }
            if (!(a instanceof AdvancedAnimation)) continue;
            IAnimationRenderer main = ((AdvancedAnimation)a).getMainAnimationRenderer();
            if (main != null && main instanceof ResourcePackAnimationRenderer) {
                ((ResourcePackAnimationRenderer)main).setupAnimationSize();
            }
            if ((intro = ((AdvancedAnimation)a).getIntroAnimationRenderer()) == null || !(intro instanceof ResourcePackAnimationRenderer)) continue;
            ((ResourcePackAnimationRenderer)intro).setupAnimationSize();
        }
    }

    public static void preloadAnimations() {
        FancyMenu.LOGGER.info("[FANCYMENU] Updating animation sizes..");
        AnimationHandler.setupAnimationSizes();
        boolean errors = false;
        if (((Boolean)FancyMenu.config.getOrDefault("preloadanimations", (Object)true)).booleanValue()) {
            if (!ready) {
                FancyMenu.LOGGER.info("[FANCYMENU] LOADING ANIMATION TEXTURES! THIS CAUSES THE LOADING SCREEN TO FREEZE FOR A WHILE!");
                try {
                    ArrayList<ResourcePackAnimationRenderer> l = new ArrayList<ResourcePackAnimationRenderer>();
                    for (IAnimationRenderer iAnimationRenderer : AnimationHandler.getAnimations()) {
                        if (iAnimationRenderer instanceof AdvancedAnimation) {
                            IAnimationRenderer main = ((AdvancedAnimation)iAnimationRenderer).getMainAnimationRenderer();
                            IAnimationRenderer intro = ((AdvancedAnimation)iAnimationRenderer).getIntroAnimationRenderer();
                            if (main != null && main instanceof ResourcePackAnimationRenderer) {
                                l.add((ResourcePackAnimationRenderer)main);
                            }
                            if (intro == null || !(intro instanceof ResourcePackAnimationRenderer)) continue;
                            l.add((ResourcePackAnimationRenderer)intro);
                            continue;
                        }
                        if (!(iAnimationRenderer instanceof ResourcePackAnimationRenderer)) continue;
                        l.add((ResourcePackAnimationRenderer)iAnimationRenderer);
                    }
                    for (ResourcePackAnimationRenderer resourcePackAnimationRenderer : l) {
                        for (ResourceLocation rl : resourcePackAnimationRenderer.getAnimationFrames()) {
                            TextureManager t = Minecraft.func_71410_x().func_110434_K();
                            ITextureObject to = t.func_110581_b(rl);
                            if (to != null) continue;
                            to = new SimpleTexture(rl);
                            t.func_110579_a(rl, to);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    errors = true;
                }
                if (!errors) {
                    FancyMenu.LOGGER.info("[FANCYMENU] FINISHED LOADING ANIMATION TEXTURES!");
                } else {
                    FancyMenu.LOGGER.warn("[FANCYMENU] FINISHED LOADING ANIMATION TEXTURES WITH ERRORS! PLEASE CHECK YOUR AIMATIONS!");
                }
                ready = true;
            }
        } else {
            ready = true;
        }
    }
}

