/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.visibilityrequirements.requirements.realtime;

import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirement;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nullable;

public class IsRealTimeSecondVisibilityRequirement
extends VisibilityRequirement {
    public IsRealTimeSecondVisibilityRequirement() {
        super("fancymenu_visibility_requirement_is_realtime_second");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        Calendar c;
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (value != null) {
            if (value.contains(",")) {
                for (String s : value.replace(" ", "").split("[,]")) {
                    if (!MathUtils.isInteger((String)s)) continue;
                    l.add(Integer.parseInt(s));
                }
            } else if (MathUtils.isInteger((String)value.replace(" ", ""))) {
                l.add(Integer.parseInt(value.replace(" ", "")));
            }
        }
        if (!l.isEmpty() && (c = Calendar.getInstance()) != null) {
            return l.contains(c.get(13));
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.realtimesecond", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.realtimesecond.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getValueDisplayName() {
        return Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.realtimesecond.valuename", (String[])new String[0]);
    }

    @Override
    public String getValuePreset() {
        return "27, 58";
    }

    @Override
    public CharacterFilter getValueInputFieldFilter() {
        CharacterFilter filter = CharacterFilter.getIntegerCharacterFiler();
        filter.addAllowedCharacters(new String[]{",", " "});
        return filter;
    }
}

