/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world.gen;

import fossilsarcheology.server.block.FABlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCordaites
extends WorldGenerator {
    private static final IBlockState LOG = FABlockRegistry.CORDAITES_LOG.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
    private static final IBlockState LEAF = FABlockRegistry.CORDAITES_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private boolean keepGenerating = true;

    public static boolean canGenTree(World world, BlockPos pos) {
        for (int y = 0; y <= 20; ++y) {
            if (WorldGenCordaites.isReplaceable(world, pos.func_177981_b(y))) continue;
            return false;
        }
        return true;
    }

    private static boolean isReplaceable(World world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || world.func_180495_p(pos).func_177230_c() == FABlockRegistry.CORDAITES_SAPLING || world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Block j1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        this.keepGenerating = true;
        boolean twins = rand.nextInt(4) != 0;
        int height = rand.nextInt(8) + 10;
        if (j1 != Blocks.field_150349_c && j1 != Blocks.field_150346_d || pos.func_177956_o() >= 115) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            this.setBlockState(world, pos.func_177972_a(facing), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)facing.func_176740_k()));
        }
        for (int i = 0; i < height; ++i) {
            this.setBlockState(world, pos.func_177981_b(i), LOG);
            EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
            int n = enumFacingArray.length;
            for (int facing = 0; facing < n; ++facing) {
                EnumFacing facing2 = enumFacingArray[facing];
                if (!((float)i > (float)height * 0.6f) || rand.nextInt(1) != 0 || !WorldGenCordaites.isReplaceable(world, pos.func_177981_b(i - 1).func_177972_a(facing2))) continue;
                int heightMinus = (int)((float)i - (float)height * 0.6f);
                this.genBranch(world, pos.func_177981_b(i), Math.max(1, 2 + rand.nextInt(2) - heightMinus), facing2, rand);
            }
        }
        this.setBlockState(world, pos.func_177981_b(height), LEAF);
        this.setBlockState(world, pos.func_177981_b(height + 1), LEAF);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            this.setBlockState(world, pos.func_177981_b(height).func_177972_a(facing), LEAF);
        }
        return true;
    }

    private void genBranch(World world, BlockPos pos, int length, EnumFacing direction, Random random) {
        int yOffset = 0;
        for (int i = 1; i <= length; ++i) {
            this.setBlockState(world, pos.func_177967_a(direction, i).func_177981_b(yOffset), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)direction.func_176740_k()));
            if (i == length) {
                this.setBlockState(world, pos.func_177967_a(direction, i + 1).func_177981_b(yOffset), LEAF);
                this.setBlockState(world, pos.func_177967_a(direction, i).func_177981_b(yOffset).func_177972_a(direction.func_176735_f()), LEAF);
                this.setBlockState(world, pos.func_177967_a(direction, i).func_177981_b(yOffset).func_177972_a(direction.func_176746_e()), LEAF);
                this.setBlockState(world, pos.func_177967_a(direction, i + 1).func_177981_b(yOffset).func_177967_a(direction.func_176735_f(), 1), LEAF);
                this.setBlockState(world, pos.func_177967_a(direction, i + 1).func_177981_b(yOffset).func_177967_a(direction.func_176746_e(), 1), LEAF);
                this.setBlockState(world, pos.func_177967_a(direction, i + 2).func_177981_b(yOffset + 1), LEAF);
            }
            if (i <= 2 || !random.nextBoolean()) continue;
            ++yOffset;
        }
    }

    public void setBlockState(World world, BlockPos pos, IBlockState state) {
        if (WorldGenCordaites.isReplaceable(world, pos)) {
            world.func_175656_a(pos, state);
        }
    }
}

