/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBelljar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderBelljar
extends TileEntitySpecialRenderer<TileEntityBelljar> {
    private static HashMap<EnumFacing, List<BakedQuad>> quads = new HashMap();
    private static HashMap<IBlockState, List<BakedQuad>> plantQuads = new HashMap();

    public void render(TileEntityBelljar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.dummy != 0 || !tile.func_145831_w().func_175668_a(tile.func_174877_v(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = tile.func_174877_v();
        if (!quads.containsKey(tile.getFacing())) {
            IBlockState state = this.func_178459_a().func_180495_p(blockPos);
            if (state.func_177230_c() != IEContent.blockMetalDevice1) {
                return;
            }
            state = state.func_185899_b((IBlockAccess)this.func_178459_a(), blockPos);
            IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
            if (state instanceof IExtendedBlockState) {
                state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(Arrays.asList("glass"), true));
            }
            quads.put(tile.getFacing(), model.func_188616_a(state, null, 0L));
        }
        ClientUtils.bindAtlas();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BufferBuilder worldRenderer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179089_o();
        BelljarHandler.IPlantHandler plantHandler = tile.getCurrentPlantHandler();
        if (plantHandler != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)1.0625, (double)0.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            NonNullList<ItemStack> inventory = tile.getInventory();
            float scale = plantHandler.getRenderSize((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile);
            GlStateManager.func_179109_b((float)((1.0f - scale) / 2.0f), (float)0.0f, (float)((1.0f - scale) / 2.0f));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (!plantHandler.overrideRender((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile, blockRenderer)) {
                IBlockState[] states = plantHandler.getRenderedPlant((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile);
                if (states == null || states.length < 1) {
                    return;
                }
                for (IBlockState s : states) {
                    List<BakedQuad> plantQuadList = plantQuads.get(s);
                    if (plantQuadList == null) {
                        IBakedModel plantModel = blockRenderer.func_184389_a(s);
                        plantQuadList = new ArrayList<BakedQuad>(plantModel.func_188616_a(s, null, 0L));
                        for (EnumFacing f : EnumFacing.values()) {
                            plantQuadList.addAll(plantModel.func_188616_a(s, f, 0L));
                        }
                        plantQuads.put(s, plantQuadList);
                    }
                    if (plantQuadList == null) continue;
                    GlStateManager.func_179094_E();
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    ClientUtils.renderModelTESRFancy(plantQuadList, worldRenderer, tile.func_145831_w(), blockPos, false);
                    Tessellator.func_178181_a().func_78381_a();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)false);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ClientUtils.renderModelTESRFast(quads.get(tile.getFacing()), worldRenderer, tile.func_145831_w(), blockPos);
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public static void reset() {
        quads.clear();
        plantQuads.clear();
    }
}

